/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.interactor.IlvChartHighlightInteractor;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class IlvChartInfoViewInteractor
extends IlvChartHighlightInteractor {
    private transient InfoViewWindow a;
    private transient StringBuffer b;
    private boolean c = false;

    public IlvChartInfoViewInteractor() {
        this(0);
    }

    public IlvChartInfoViewInteractor(int n2) {
        super(n2);
        this.b();
    }

    private void b() {
        this.a = null;
        this.b = new StringBuffer();
    }

    public void setFollowingMouse(boolean bl) {
        this.c = bl;
    }

    public boolean isFollowingMouse() {
        return this.c;
    }

    protected String getInfoText(IlvDisplayPoint ilvDisplayPoint) {
        double d2 = ilvDisplayPoint.getXData();
        double d3 = ilvDisplayPoint.getYData();
        int n2 = ilvDisplayPoint.getIndex();
        String string = ilvDisplayPoint.getDataSet().getName();
        this.b.setLength(0);
        if (IlvSwingUtil.isHTMLToolTipsSupported()) {
            Font font = UIManager.getFont("ToolTip.font");
            if (font != null) {
                this.b.append("<html><font face=\"");
                this.b.append(font.getName());
                this.b.append("\" size=\"-1\">");
            } else {
                this.b.append("<html>");
            }
            if (string != null) {
                this.b.append("<p align=\"center\">");
                this.b.append(string);
            }
            this.b.append("<p align=\"center\">(");
            this.b.append(this.getChart().formatXValue(d2));
            this.b.append(";");
            this.b.append(this.getChart().formatYValue(this.getYAxisIndex(), d3));
            this.b.append(")");
            this.b.append("</html>");
        } else {
            if (string != null) {
                this.b.append(string);
                this.b.append(" ");
            }
            this.b.append("(");
            this.b.append(this.getChart().formatXValue(d2));
            this.b.append(";");
            this.b.append(this.getChart().formatYValue(this.getYAxisIndex(), d3));
            this.b.append(")");
        }
        return this.b.toString();
    }

    protected IlvDisplayPoint pickData(IlvChartDataPicker ilvChartDataPicker) {
        if (this.getChart().getType() == 3) {
            return this.getChart().getDisplayItem(ilvChartDataPicker);
        }
        return super.pickData(ilvChartDataPicker);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (this.c && !mouseEvent.isConsumed() && mouseEvent.getID() == 503 && this.getHighlightedPoint() != null && this.a != null) {
            Dimension dimension = this.a.getSize();
            Point point = this.computePosition(dimension, mouseEvent.getX(), mouseEvent.getY());
            SwingUtilities.convertPointToScreen(point, this.getChart().getChartArea());
            this.a.showTip(this.getChart(), point.x, point.y);
        }
    }

    public void interactionStarted(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
        if (this.getHighlightedPoint() != null) {
            this.doIt(this.getHighlightedPoint(), false, mouseEvent);
            this.setHighlightedPoint(null);
        }
    }

    protected void doIt(IlvDisplayPoint ilvDisplayPoint, boolean bl, MouseEvent mouseEvent) {
        if (bl) {
            String string;
            if (this.a == null) {
                this.a = new InfoViewWindow();
            }
            if ((string = this.getInfoText(ilvDisplayPoint)) == null) {
                return;
            }
            this.a.setText(string);
            Dimension dimension = this.a.getSize();
            Point point = this.computePosition(dimension, mouseEvent.getX(), mouseEvent.getY());
            SwingUtilities.convertPointToScreen(point, this.getChart().getChartArea());
            this.a.showTip(this.getChart(), point.x, point.y);
        } else if (this.a != null) {
            this.a.hideTip();
            this.a.setText(null);
        }
        super.doIt(ilvDisplayPoint, bl, mouseEvent);
    }

    protected Point computePosition(Dimension dimension, int n2, int n3) {
        Point point = new Point();
        point.x = n2 - dimension.width / 2;
        point.y = n3 - dimension.height - 5;
        return point;
    }

    public boolean isHandling(int n2, int n3) {
        return true;
    }

    protected JToolTip createToolTip() {
        return new JToolTip();
    }

    protected JToolTip getToolTip() {
        return this.a != null ? this.a.a : null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b();
    }

    static {
        IlvChartInteractor.register("InfoView", IlvChartInfoViewInteractor.class);
    }

    class InfoViewWindow
    extends JPanel {
        JToolTip a;

        public InfoViewWindow() {
            this(null);
        }

        public InfoViewWindow(String string) {
            this.setLayout(new BorderLayout());
            this.a = IlvChartInfoViewInteractor.this.createToolTip();
            this.a.setComponent(IlvChartInfoViewInteractor.this.getChart());
            this.a.setTipText(string);
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.add((Component)this.a, "Center");
            this.setSize(this.a.getPreferredSize());
        }

        public void setText(String string) {
            this.a.setTipText(string);
            this.setSize(this.a.getPreferredSize());
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void showTip(JComponent jComponent, int n2, int n3) {
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointFromScreen(point, jComponent.getRootPane().getLayeredPane());
            this.setLocation(point.x, point.y);
            jComponent.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
        }

        public void hideTip() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

