/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvCartesianProjector;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvPolarProjector;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvScaleConfiguration;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

class IlvRectangularScaleConfiguration
extends IlvScaleConfiguration {
    private transient IlvDoublePoints a;
    private transient double b;
    private transient int c;
    private transient int d;

    IlvRectangularScaleConfiguration() {
    }

    protected Rectangle2D getAxisBounds(Rectangle2D rectangle2D) {
        IlvDoublePoints ilvDoublePoints = this.g();
        int n2 = (int)Math.floor(ilvDoublePoints.getX(0));
        int n3 = (int)Math.floor(ilvDoublePoints.getY(0));
        if (rectangle2D == null) {
            rectangle2D = new Rectangle(n2, n3, 1, 1);
        } else {
            rectangle2D.setRect(n2, n3, 1.0, 1.0);
        }
        rectangle2D.add(ilvDoublePoints.getX(1), ilvDoublePoints.getY(1));
        this.scale.b().expand(rectangle2D);
        return rectangle2D;
    }

    int a(int n2, int n3, int n4) {
        double d2 = this.f();
        double d3 = IlvMathUtil.sinDeg(d2 += this.scale.getLabelRotation());
        double d4 = IlvMathUtil.cosDeg(d2);
        int n5 = this.getScaleLength();
        double d5 = Math.abs((double)n2 * d4) + Math.abs((double)n3 * d3) + (double)n4;
        return (int)Math.max(Math.round((double)n5 / d5) + 1L, 2L);
    }

    protected void draw(Graphics graphics) {
        if (this.l()) {
            graphics.translate(this.c, this.d);
        }
        super.draw(graphics);
        if (this.l()) {
            graphics.translate(-this.c, -this.d);
        }
    }

    synchronized void a(Rectangle2D rectangle2D) {
        super.a(rectangle2D);
        if (this.l()) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.c, rectangle2D.getY() + (double)this.d, rectangle2D.getWidth(), rectangle2D.getHeight());
            if (this.scale.l()) {
                Rectangle2D rectangle2D2 = this.scale.i().getBounds(null);
                rectangle2D2.setRect(rectangle2D2.getX() + (double)this.c, rectangle2D2.getY() + (double)this.d, rectangle2D2.getWidth(), rectangle2D2.getHeight());
                IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
            }
        } else if (this.scale.l()) {
            IlvGraphicUtil.addToRect(rectangle2D, this.scale.i().getBounds(null));
        }
    }

    int b() {
        double d2 = this.scale.e().getPlacement();
        if (d2 == 100.0 || d2 == 0.0) {
            return this.scale.getTitleOffset();
        }
        int n2 = this.scale.getTitleOffset() + this.scale.w();
        if (this.scale.isLabelVisible()) {
            n2 = (int)((double)n2 + (this.i() ? this.scale.m().l() : this.scale.m().k()));
        }
        return n2;
    }

    double a(double d2) {
        if (this.scale.n()) {
            boolean bl;
            IlvAxis ilvAxis = this.scale.getAxis();
            IlvAxis ilvAxis2 = this.scale.getDualAxis();
            double d3 = this.scale.getCrossingValue();
            if (ilvAxis2.isReversed()) {
                bl = d3 == ilvAxis2.getVisibleMin();
            } else {
                boolean bl2 = bl = d3 == ilvAxis2.getVisibleMax();
            }
            d3 = ilvAxis.isXAxis() && !this.scale.getChart().isProjectorReversed() || ilvAxis.isYAxis() && this.scale.getChart().isProjectorReversed() ? (bl ? 90.0 : -90.0) : (bl ? -90.0 : 90.0);
            return ilvAxis.isReversed() ? this.b - d3 : this.b + d3;
        }
        if (this.c()) {
            return this.h();
        }
        return this.b + 90.0;
    }

    private double h() {
        double d2 = this.d().getAxisAngle(this.scale.getDualAxis());
        return this.scale.getCrossing() == IlvAxis.MAX_VALUE ? d2 : d2 + 180.0;
    }

    protected int getScaleLength() {
        if (this.c() && !this.scale.getChart().is3D()) {
            return (int)this.d().getAxisLength(this.scale.q(), this.scale.getAxis());
        }
        IlvDoublePoints ilvDoublePoints = this.g();
        if (ilvDoublePoints == null) {
            return 0;
        }
        double d2 = ilvDoublePoints.getX(1) - ilvDoublePoints.getX(0);
        double d3 = ilvDoublePoints.getY(1) - ilvDoublePoints.getY(0);
        return (int)Math.sqrt(d2 * d2 + d3 * d3);
    }

    boolean a(Graphics graphics) {
        this.e();
        this.k();
        return super.a(graphics);
    }

    IlvAxis.Crossing a() {
        IlvChart ilvChart = this.scale.getChart();
        IlvAxis.Crossing crossing = IlvAxis.MIN_VALUE;
        if (ilvChart != null) {
            if (this.scale.getAxis().isXAxis()) {
                crossing = IlvAxis.MIN_VALUE;
            } else {
                int n2;
                for (n2 = 0; n2 < ilvChart.getYAxisCount() && ilvChart.getYScale(n2) != this.scale; ++n2) {
                }
                crossing = n2 == 0 ? IlvAxis.MIN_VALUE : IlvAxis.MAX_VALUE;
            }
        }
        return crossing;
    }

    final boolean c() {
        return this.scale.o() instanceof IlvCartesianProjector;
    }

    final IlvCartesianProjector d() {
        return (IlvCartesianProjector)this.scale.o();
    }

    protected void drawAxis(Graphics graphics) {
        IlvDoublePoints ilvDoublePoints = this.g();
        this.scale.b().drawLine(graphics, ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1));
    }

    void e() {
        double[] dArray = null;
        dArray = this.scale.getChart().getType() == 2 && ((IlvPolarProjector)this.scale.o()).isSymmetric() ? new double[]{-this.scale.getAxis().getVisibleMax(), this.scale.getAxis().getVisibleMax()} : new double[]{this.scale.getAxis().getVisibleMin(), this.scale.getAxis().getVisibleMax()};
        this.a = this.scale.a(dArray, 2);
        this.b = IlvGraphicUtil.pointAngleDeg(this.a.getX(0), this.a.getY(0), this.a.getX(1), this.a.getY(1));
    }

    final double f() {
        return this.b;
    }

    private final boolean i() {
        return this.b == 0.0 || this.b == 180.0;
    }

    private final boolean j() {
        return this.b == 90.0 || this.b == 270.0;
    }

    final IlvDoublePoints g() {
        return this.a;
    }

    private void k() {
        this.d = 0;
        this.c = 0;
        if (!this.c() || this.scale.n()) {
            return;
        }
        IlvScale ilvScale = this.scale.j();
        if (ilvScale == null) {
            return;
        }
        double d2 = ((IlvRectangularScaleConfiguration)ilvScale.a()).h();
        int n2 = (int)IlvMathUtil.cosDeg(d2);
        int n3 = (int)IlvMathUtil.sinDeg(d2);
        while (ilvScale != null) {
            Rectangle2D rectangle2D = ilvScale.getBounds(null);
            int n4 = ((int)rectangle2D.getWidth() + 10 + 1) * n2;
            int n5 = -((int)rectangle2D.getHeight() + 10 + 1) * n3;
            if (n4 != 0) {
                this.c += n4;
            }
            if (n5 != 0) {
                this.d += n5;
            }
            ilvScale = ilvScale.j();
        }
    }

    private final boolean l() {
        return this.c != 0 || this.d != 0;
    }

    protected void computeTitleLocation(IlvDoublePoint ilvDoublePoint) {
        double d2;
        double d3;
        IlvDoublePoints ilvDoublePoints;
        double d4 = this.scale.e().getPlacement();
        if (this.scale.getAxis().getVisibleRange().getLength() == 0.0 || this.scale.getDualAxis().getVisibleRange().getLength() == 0.0) {
            Rectangle rectangle = this.scale.q();
            ilvDoublePoints = new IlvDoublePoints(2);
            if (this.scale.getAxis().isXAxis() && !this.scale.getChart().isProjectorReversed() || this.scale.getAxis().isYAxis() && this.scale.getChart().isProjectorReversed()) {
                ilvDoublePoints.add(rectangle.x, rectangle.y + rectangle.height);
                ilvDoublePoints.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                d3 = 0.0;
            } else {
                ilvDoublePoints.add(rectangle.x, rectangle.y + rectangle.height);
                ilvDoublePoints.add(rectangle.x, rectangle.y);
                d3 = 90.0;
            }
        } else {
            ilvDoublePoints = this.g();
            d3 = this.f();
        }
        if (d4 == 100.0) {
            ilvDoublePoint.x = ilvDoublePoints.getX(1);
            ilvDoublePoint.y = ilvDoublePoints.getY(1);
            d2 = d3;
        } else if (d4 == 0.0) {
            ilvDoublePoint.x = ilvDoublePoints.getX(0);
            ilvDoublePoint.y = ilvDoublePoints.getY(0);
            d2 = d3 + 180.0;
        } else {
            ilvDoublePoint.x = ilvDoublePoints.getX(0) + (ilvDoublePoints.getX(1) - ilvDoublePoints.getX(0)) * d4 / 100.0;
            ilvDoublePoint.y = ilvDoublePoints.getY(0) + (ilvDoublePoints.getY(1) - ilvDoublePoints.getY(0)) * d4 / 100.0;
            d2 = this.a(0.0);
        }
        Dimension2D dimension2D = this.scale.e().getSize2D(true);
        IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d2, this.b(), dimension2D.getWidth(), dimension2D.getHeight());
    }
}

