/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.IlvScalableFontManager;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.IlvTextRenderer;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvDimension2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class IlvLabelRenderer
implements Serializable,
SwingConstants {
    private transient IlvTextRenderer a = new IlvTextRenderer();
    private IlvStyle b;
    private Color c;
    private Color d;
    private Border e;
    private boolean f;
    private boolean g;
    private Font h;
    private boolean i = true;

    public IlvLabelRenderer() {
        this.a();
        this.b = new IlvStyle(Color.white);
        this.b.setAbsolutePaint(false);
    }

    public IlvLabelRenderer(Color color, Color color2) {
        this();
        this.e = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color2), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.f = true;
        this.d = color2;
        this.setBackground(color);
    }

    public void setScalingFont(boolean bl) {
        this.i = bl;
    }

    public final boolean isScalingFont() {
        return this.i;
    }

    public final Font getFont() {
        return this.h;
    }

    public void setFont(Font font) {
        this.h = font;
        this.stateChanged();
    }

    public final Color getColor() {
        return this.d;
    }

    public void setColor(Color color) {
        this.d = color;
        this.stateChanged();
    }

    public void setBackground(Color color) {
        this.setBackgroundPaint(color);
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint != null) {
            this.g = true;
            this.b.b(paint);
        } else {
            this.g = false;
        }
        this.stateChanged();
    }

    public final Color getBackground() {
        return this.g ? this.b.getFillColor() : null;
    }

    public final Paint getBackgroundPaint() {
        return this.g ? this.b.getFillPaint() : null;
    }

    public final double getRotation() {
        return this.a.getRotation();
    }

    public void setRotation(double d2) {
        this.a.setRotation(d2);
        this.stateChanged();
    }

    private Font a(Component component) {
        IlvScalableFontManager ilvScalableFontManager = IlvScalableFontManager.getFontManager(component);
        Font font = this.h == null ? component.getFont() : (this.i && ilvScalableFontManager != null ? ilvScalableFontManager.getDeriveFont(this.h) : this.h);
        return font;
    }

    public void paintLabel(JComponent jComponent, Graphics graphics, String string, int n2, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        Rectangle rectangle = null;
        if (this.f || this.e != null) {
            rectangle = IlvGraphicUtil.toRectangle(this.getBounds(jComponent, n2, n3, string, null), null);
        } else {
            this.a(jComponent, string);
        }
        Color color = graphics.getColor();
        if (this.f) {
            if (!this.g) {
                this.b.b(jComponent.getBackground());
            }
            this.b.fillRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color2 = this.d == null ? jComponent.getForeground() : this.d;
        graphics.setColor(color2);
        this.a.draw(graphics, n2, n3);
        if (this.e != null) {
            this.e.paintBorder(jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(color);
    }

    private final void a(JComponent jComponent, String string) {
        this.a.setFont(this.a((Component)jComponent));
        this.a.setText(string);
        this.a.setAntiAliased(this.a(jComponent));
    }

    public Rectangle2D getBounds(JComponent jComponent, int n2, int n3, String string, Rectangle2D rectangle2D) {
        Insets insets;
        if (string == null || string.length() == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        this.a(jComponent, string);
        double d2 = this.a.getWidth();
        double d3 = this.a.getHeight();
        if (this.e != null && (insets = this.e.getBorderInsets(jComponent)) != null) {
            d2 += (double)(insets.left + insets.right);
            d3 += (double)(insets.top + insets.bottom);
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double((double)n2 - d2 / 2.0, (double)n3 - d3 / 2.0, d2, d3);
        } else {
            rectangle2D.setRect((double)n2 - d2 / 2.0, (double)n3 - d3 / 2.0, d2, d3);
        }
        return rectangle2D;
    }

    public Dimension2D getSize2D(JComponent jComponent, String string, boolean bl, boolean bl2) {
        Insets insets;
        if (string == null || string.length() == 0) {
            return new IlvDimension2D(0.0, 0.0);
        }
        this.a(jComponent, string);
        Rectangle2D rectangle2D = this.a.getBounds(bl2);
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        if (bl && this.e != null && (insets = this.e.getBorderInsets(jComponent)) != null) {
            d2 += (double)(insets.left + insets.right);
            d3 += (double)(insets.top + insets.bottom);
        }
        return new IlvDimension2D(d2, d3);
    }

    public Dimension getSize(JComponent jComponent, String string, boolean bl, boolean bl2) {
        Insets insets;
        if (string == null || string.length() == 0) {
            return new Dimension(0, 0);
        }
        this.a(jComponent, string);
        Rectangle2D rectangle2D = this.a.getBounds(bl2);
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        if (bl && this.e != null && (insets = this.e.getBorderInsets(jComponent)) != null) {
            d2 += (double)(insets.left + insets.right);
            d3 += (double)(insets.top + insets.bottom);
        }
        return new Dimension((int)Math.ceil(d2), (int)Math.ceil(d3));
    }

    public Dimension getSize(JComponent jComponent, String string) {
        Dimension2D dimension2D = this.getSize2D(jComponent, string, true, false);
        return new Dimension((int)Math.ceil(dimension2D.getWidth()), (int)Math.ceil(dimension2D.getHeight()));
    }

    public Dimension getTextSize(JComponent jComponent, String string) {
        Dimension2D dimension2D = this.getSize2D(jComponent, string, false, false);
        return new Dimension((int)Math.ceil(dimension2D.getWidth()), (int)Math.ceil(dimension2D.getHeight()));
    }

    public Dimension getRSize(JComponent jComponent, String string) {
        Dimension2D dimension2D = this.getSize2D(jComponent, string, true, true);
        return new Dimension((int)Math.ceil(dimension2D.getWidth()), (int)Math.ceil(dimension2D.getHeight()));
    }

    protected void stateChanged() {
    }

    public void setBorder(Border border) {
        this.e = border;
    }

    public final Border getBorder() {
        return this.e;
    }

    public void setOpaque(boolean bl) {
        this.f = bl;
    }

    public final boolean isOpaque() {
        return this.f;
    }

    public final int getAlignment() {
        return this.a.getAlignment();
    }

    public void setAlignment(int n2) {
        this.a.setAlignment(n2);
    }

    public final boolean isAutoWrapping() {
        return this.a.isAutoWrapping();
    }

    public void setAutoWrapping(boolean bl) {
        this.a.setAutoWrapping(bl);
    }

    public final float getWrappingWidth() {
        return this.a.getWrappingWidth();
    }

    public void setWrappingWidth(float f2) {
        this.a.setWrappingWidth(f2);
    }

    private final boolean a(JComponent jComponent) {
        if (jComponent instanceof IlvChart.Area) {
            return ((IlvChart.Area)jComponent).getChart().isAntiAliasingText();
        }
        if (jComponent instanceof IlvLegend) {
            return ((IlvLegend)jComponent).isAntiAliasingText();
        }
        return jComponent.getClientProperty("_AA_") != null;
    }

    private void a() {
        this.a = new IlvTextRenderer();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a();
    }
}

