/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DSupport;
import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.data.IlvDefaultDataSource;
import ilog.views.chart.data.lod.IlvLODDataSet;
import ilog.views.chart.data.lod.IlvLODHandler;
import ilog.views.chart.data.xml.IlvXMLDataSource;
import ilog.views.chart.event.DataSourceEvent;
import ilog.views.chart.event.DataSourceListener;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvAreaChartRenderer;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import ilog.views.chart.renderer.IlvBubbleChartRenderer;
import ilog.views.chart.renderer.IlvComboChartRenderer;
import ilog.views.chart.renderer.IlvCompositeChartRenderer;
import ilog.views.chart.renderer.IlvHiLoChartRenderer;
import ilog.views.chart.renderer.IlvPieChartRenderer;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import ilog.views.chart.renderer.IlvScatterChartRenderer;
import ilog.views.chart.renderer.IlvStairChartRenderer;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.styling.IlvStylingSupport;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvFlags;
import ilog.views.util.collections.IlvCollections;
import ilog.views.util.styling.IlvStylingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class IlvChartRenderer
implements IlvChart3DSupport,
Serializable {
    public static final int BAR = 0;
    public static final int STACKED_BAR = 1;
    public static final int SUPERIMPOSED_BAR = 2;
    public static final int AREA = 3;
    public static final int STACKED_AREA = 4;
    public static final int POLYLINE = 5;
    public static final int SCATTER = 6;
    public static final int STAIR = 7;
    public static final int BUBBLE = 8;
    public static final int HILO = 9;
    public static final int PIE = 10;
    public static final int STACKED_POLYLINE = 11;
    public static final int CANDLE = 12;
    public static final int HLOC = 13;
    public static final int STACKED_STAIR = 14;
    public static final int SUMMED_STAIR = 15;
    public static final int COMBO = 16;
    public static final int STACKED100_BAR = 17;
    public static final int STACKED100_POLYLINE = 18;
    public static final int STACKED100_AREA = 19;
    public static final int STACKED100_STAIR = 20;
    public static final int HILO_ARROW = 21;
    public static final int HILO_STICK = 22;
    public static final int DATA_LABEL = 1;
    public static final int Y_VALUE_LABEL = 2;
    public static final int XY_VALUES_LABEL = 3;
    public static final int X_VALUE_LABEL = 4;
    public static final int PERCENT_LABEL = 5;
    public static final int CENTERED_LABEL_LAYOUT = 1;
    public static final int OUTSIDE_LABEL_LAYOUT = 2;
    public static final int DEFAULT_LABEL_LAYOUT = 1;
    public static final int DEFAULT_LABELING = 2;
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 1;
    private static final ArrayList d = new ArrayList(0);
    private static HashMap e = new HashMap();
    private IlvChart f;
    private IlvChart.AxisElement g;
    private String h;
    private IlvChartRenderer i;
    private IlvFlags j = new IlvFlags(1);
    private double k;
    private IlvDataSource l;
    private DataSourceListener m;
    private IlvDataAnnotation n;
    private IlvDataRenderingHint o;
    private Integer p;
    private Integer q;
    private Boolean r;

    protected static void register(String string, Class clazz) {
        e.put(string, clazz);
    }

    public static IlvChartRenderer create(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Class<?> clazz = (Class<?>)e.get(string);
        if (clazz == null) {
            clazz = Class.forName(string);
        }
        IlvChartRenderer ilvChartRenderer = null;
        if (clazz == null) {
            throw new ClassNotFoundException("Unknown class: " + string);
        }
        ilvChartRenderer = (IlvChartRenderer)clazz.newInstance();
        return ilvChartRenderer;
    }

    protected IlvChartRenderer() {
        this.setDataSource(new IlvDefaultDataSource());
    }

    public final IlvChart getChart() {
        if (this.f == null) {
            return this.i == null ? null : this.i.getChart();
        }
        return this.f;
    }

    void a(IlvChart ilvChart, IlvChart.AxisElement axisElement) {
        Object object;
        if (this.f == ilvChart) {
            return;
        }
        IlvChart ilvChart2 = this.f;
        this.f = ilvChart;
        if (ilvChart2 != null && (object = IlvStylingSupport.get(ilvChart2)) != null && ((IlvStylingSupport)object).isLogging(this)) {
            ((IlvStylingSupport)object).setLogging(this, false);
        }
        if (ilvChart != null) {
            this.g = axisElement;
            object = IlvStylingSupport.get(ilvChart);
            if (object != null && !((IlvStylingSupport)object).isLogging(this)) {
                ((IlvStylingSupport)object).setLogging(this, true);
            }
            ilvChart.a(this, 1);
        } else {
            this.g = null;
            ilvChart2.a(this, 2);
        }
        this.e();
        this.chartConnected(ilvChart2, ilvChart);
        object = this.getChildIterator();
        while (object.hasNext()) {
            ((IlvChartRenderer)object.next()).a(ilvChart, axisElement);
        }
        this.c();
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        if (ilvChart2 != null) {
            this.a(this.getDataSource().getDataSets(), true, ilvChart);
        } else {
            this.a(this.getDataSource().getDataSets(), false, ilvChart);
        }
    }

    public final Rectangle getPlotRect() {
        if (this.i != null) {
            return this.i.getPlotRect();
        }
        return this.f.getChartArea().getPlotRect();
    }

    public Rectangle getClipRect() {
        return this.getPlotRect();
    }

    public boolean isVisible() {
        return this.j.getFlag(1);
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        this.j.setFlag(1, bl);
        this.e();
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        IlvChart.AxisElement axisElement = this.a();
        return axisElement == null ? null : axisElement.g();
    }

    public final int getYAxisIdx() {
        IlvChart.AxisElement axisElement = this.a();
        return axisElement == null ? -1 : axisElement.b();
    }

    final IlvChart.AxisElement a() {
        if (this.g == null) {
            return this.i == null ? null : this.i.a();
        }
        return this.g;
    }

    void a(IlvChart.AxisElement axisElement) {
        this.g = axisElement;
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            ((IlvChartRenderer)iterator.next()).a(axisElement);
        }
        this.e();
    }

    public void toData(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            ilvChart.getProjector().toData(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.b; ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            ilvChart.getProjector().toDisplay(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    public String getName() {
        return this.h;
    }

    public void setName(String string) {
        this.h = string;
        this.triggerChange(6);
    }

    public void setXShift(double d2) {
        this.k = d2;
        this.triggerChange(5);
    }

    public double getXShift() {
        return this.i == null ? this.k : this.k + this.i.getXShift();
    }

    public boolean isViewable() {
        return this.j.getFlag(2) && (!this.getChart().is3D() || this.has3DSupport());
    }

    public abstract IlvDataInterval getXRange(IlvDataInterval var1);

    public abstract IlvDataInterval getYRange(IlvDataInterval var1);

    public abstract IlvDataInterval getYRange(IlvDataInterval var1, IlvDataInterval var2);

    int b() {
        return Integer.MAX_VALUE;
    }

    public int getMinDataSetCount() {
        return 1;
    }

    public final IlvDataSource getDataSource() {
        return this.l;
    }

    public int getDataSetIndex(IlvDataSet ilvDataSet) {
        return this.l == null ? -1 : this.l.getDataSetIndex(ilvDataSet);
    }

    public void setDataSource(IlvDataSource ilvDataSource) {
        if (ilvDataSource == null) {
            throw new IllegalArgumentException();
        }
        IlvDataSource ilvDataSource2 = this.getDataSource();
        if (ilvDataSource2 == ilvDataSource) {
            return;
        }
        if (ilvDataSource2 != null) {
            this.b(ilvDataSource2);
        }
        this.l = ilvDataSource;
        this.a(ilvDataSource);
        this.triggerChange(7);
        this.e();
    }

    private void a(IlvDataSource ilvDataSource) {
        ilvDataSource.addDataSourceListener(this.d());
        if (ilvDataSource.getDataSetCount() > 0) {
            this.dataSetsAdded(0, ilvDataSource.getDataSetCount() - 1, new IlvDataSet[0]);
            if (this.getChart() != null) {
                this.a(ilvDataSource.getDataSets(), true, null);
            }
        }
        this.c();
    }

    private void c() {
        String[] stringArray;
        if (this.l instanceof IlvXMLDataSource && (stringArray = ((IlvXMLDataSource)this.l).getStyleSheets()) != null && this.getChart() != null && !this.getChart().e().isStyling()) {
            try {
                this.getChart().setStyleSheets(stringArray);
            }
            catch (IlvStylingException ilvStylingException) {
                ilvStylingException.printStackTrace();
            }
        }
    }

    private void b(IlvDataSource ilvDataSource) {
        IlvDataSet[] ilvDataSetArray = ilvDataSource.getDataSets();
        ilvDataSource.removeDataSourceListener(this.d());
        if (ilvDataSetArray.length > 0) {
            this.dataSetsRemoved(0, ilvDataSetArray.length - 1, ilvDataSetArray);
            if (this.getChart() != null) {
                this.a(ilvDataSource.getDataSets(), false, null);
            }
        }
    }

    public final boolean isDisplayingDataSet(IlvDataSet ilvDataSet) {
        return this.l != null && this.l.containsDataSet(ilvDataSet);
    }

    public abstract void setDisplayPoint(IlvDataSet var1, int var2, double var3, double var5);

    public abstract void setDataPoint(IlvDataSet var1, int var2, double var3, double var5);

    public void addImageMapAreas(IlvIMapDefinition ilvIMapDefinition, List list) {
        int n2 = this.getChildCount();
        IlvChartRenderer ilvChartRenderer = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable() || !ilvIMapDefinition.mustGenerate(ilvChartRenderer)) continue;
            ilvChartRenderer.addImageMapAreas(ilvIMapDefinition, list);
        }
    }

    private synchronized DataSourceListener d() {
        if (this.m == null) {
            this.m = new DataSourceLST();
        }
        return this.m;
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
    }

    void a(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
    }

    public abstract void setStyles(IlvStyle[] var1);

    public void setStyle(int n2, IlvStyle ilvStyle) {
        IlvStyle[] ilvStyleArray = this.getStyles();
        if (ilvStyleArray != null && n2 < ilvStyleArray.length) {
            ilvStyleArray[n2] = ilvStyle;
            this.setStyles(ilvStyleArray);
        }
    }

    public IlvStyle getStyle(int n2) {
        IlvStyle[] ilvStyleArray = this.getStyles();
        return ilvStyleArray != null && n2 < ilvStyleArray.length ? ilvStyleArray[n2] : null;
    }

    public Color[] getDefaultColors() {
        if (this.i != null) {
            return this.i.getDefaultColors();
        }
        if (this.f != null) {
            return this.f.getDefaultColors();
        }
        return null;
    }

    public abstract IlvStyle[] getStyles();

    public abstract IlvStyle getStyle(IlvDataSet var1, int var2);

    public abstract void draw(Graphics var1);

    public abstract void drawAnnotations(Graphics var1);

    public abstract void draw(Graphics var1, IlvDataSet var2, int var3, int var4);

    public abstract Rectangle2D getBounds(IlvDataSet var1, int var2, int var3, Rectangle2D var4);

    public abstract Rectangle2D getBounds(IlvDataSet var1, int var2, int var3, Rectangle2D var4, boolean var5);

    public boolean has3DSupport() {
        return false;
    }

    protected void set3D(boolean bl) {
    }

    public double[] getDepths() {
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null && !this.has3DSupport()) {
            return null;
        }
        IlvChart3DView ilvChart3DView = ilvChart.get3DView();
        double[] dArray = null;
        Iterator iterator = null;
        if (this.getParent() != null) {
            dArray = this.getParent().getDepths();
            if (dArray == null) {
                return null;
            }
            iterator = this.getParent().getChildIterator();
        } else {
            iterator = ilvChart.getRendererIterator();
            dArray = new double[]{ilvChart3DView.getFrontDepth(), ilvChart3DView.getBackDepth()};
        }
        int n2 = 0;
        int n3 = 0;
        IlvChartRenderer ilvChartRenderer = null;
        while (iterator.hasNext()) {
            ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (ilvChartRenderer == this) {
                n3 = n2;
            }
            if (!ilvChartRenderer.isViewable()) continue;
            ++n2;
        }
        double d2 = (dArray[0] - dArray[1]) / (double)n2;
        dArray[0] = ilvChart.getType() == 3 ? dArray[0] - d2 * (double)n3 : dArray[0] - d2 * (double)(n2 - n3 - 1);
        dArray[1] = dArray[0] - d2;
        if (this.getParent() != null || this.getChildCount() == 0) {
            double d3 = d2 * (double)ilvChart.get3DView().getDepthGap() / 200.0;
            dArray[0] = dArray[0] - d3;
            dArray[1] = dArray[1] + d3;
        }
        return dArray;
    }

    public int getChildCount() {
        return 0;
    }

    public Iterator getChildIterator() {
        return IlvCollections.emptyIterator();
    }

    public List getChildren() {
        return d;
    }

    public IlvChartRenderer getChild(int n2) {
        return null;
    }

    public IlvChartRenderer getParent() {
        return this.i;
    }

    public void setParent(IlvChartRenderer ilvChartRenderer) {
        if (ilvChartRenderer != null && this.i != null) {
            throw new IllegalArgumentException("Renderer already connected to a parent");
        }
        if (this.getChart() != null) {
            throw new IllegalArgumentException("Renderer already connected to a chart");
        }
        this.i = ilvChartRenderer;
        this.a(ilvChartRenderer.getChart(), ilvChartRenderer.a());
    }

    public abstract IlvDisplayPoint getNearestPoint(IlvChartDataPicker var1);

    public abstract IlvDisplayPoint getDisplayItem(IlvChartDataPicker var1);

    public abstract IlvDisplayPoint getDisplayPoint(IlvDataSet var1, int var2);

    public abstract void drawLegendSymbol(IlvLegendItem var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract IlvLegendItem[] createLegendItems();

    public String getLegendText(IlvLegendItem ilvLegendItem) {
        return this.getName();
    }

    public IlvStyle getLegendStyle() {
        return this.getStyle(0);
    }

    public Insets getPreferredMargins() {
        Insets insets = new Insets(0, 0, 0, 0);
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (!ilvChartRenderer.isViewable()) continue;
            insets = IlvGraphicUtil.mergeInsets(insets, ilvChartRenderer.getPreferredMargins());
        }
        return insets;
    }

    public static IlvDisplayPoint getDisplayItem(Iterator iterator, IlvChartDataPicker ilvChartDataPicker) {
        IlvChartRenderer ilvChartRenderer;
        IlvDisplayPoint ilvDisplayPoint = null;
        while (!(!iterator.hasNext() || (ilvChartRenderer = (IlvChartRenderer)iterator.next()).isViewable() && ilvChartDataPicker.accept(ilvChartRenderer) && (ilvDisplayPoint = ilvChartRenderer.getDisplayItem(ilvChartDataPicker)) != null)) {
        }
        return ilvDisplayPoint;
    }

    public static IlvDisplayPoint getNearestPoint(Iterator iterator, IlvChartDataPicker ilvChartDataPicker) {
        IlvDisplayPoint ilvDisplayPoint = null;
        double d2 = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double d3;
            double d4;
            double d5;
            IlvDisplayPoint ilvDisplayPoint2;
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (!ilvChartRenderer.isViewable() || !ilvChartDataPicker.accept(ilvChartRenderer) || (ilvDisplayPoint2 = ilvChartRenderer.getNearestPoint(ilvChartDataPicker)) == null || !((d5 = (d4 = ilvDisplayPoint2.getXCoord() - (double)ilvChartDataPicker.getPickX()) * d4 + (d3 = ilvDisplayPoint2.getYCoord() - (double)ilvChartDataPicker.getPickY()) * d3) < d2)) continue;
            d2 = d5;
            ilvDisplayPoint = ilvDisplayPoint2;
        }
        return ilvDisplayPoint;
    }

    protected void triggerChange(int n2) {
        if (this.f != null) {
            this.f.a(this, n2);
        }
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.isVisibleInLegend()) {
            return;
        }
        this.r = new Boolean(bl);
        this.triggerChange(6);
    }

    public boolean isVisibleInLegend() {
        return this.r == null ? (this.getParent() == null ? true : this.getParent().isVisibleInLegend()) : this.r;
    }

    public void setDataLabelling(int n2) {
        this.p = new Integer(n2);
        if (this.getChart() != null) {
            this.getChart().getChartArea().revalidate();
            this.getChart().getChartArea().repaint();
        }
    }

    public int getDataLabelling() {
        return this.p == null ? (this.getParent() == null ? 2 : this.getParent().getDataLabelling()) : this.p;
    }

    public void setDataLabelLayout(int n2) {
        this.q = new Integer(n2);
        if (this.getChart() != null) {
            this.getChart().getChartArea().revalidate();
            this.getChart().getChartArea().repaint();
        }
    }

    public int getDataLabelLayout() {
        return this.q == null ? (this.getParent() == null ? 1 : this.getParent().getDataLabelLayout()) : this.q;
    }

    public abstract void setAnnotation(IlvDataSet var1, int var2, IlvDataAnnotation var3);

    public abstract void setAnnotation(IlvDataSet var1, IlvDataAnnotation var2);

    public void setAnnotation(IlvDataAnnotation ilvDataAnnotation) {
        this.n = ilvDataAnnotation;
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    public final IlvDataAnnotation getAnnotation() {
        return this.n;
    }

    public abstract IlvDataAnnotation getAnnotation(IlvDataSet var1, int var2);

    public abstract void setRenderingHint(IlvDataSet var1, int var2, IlvDataRenderingHint var3);

    public abstract void setRenderingHint(IlvDataSet var1, IlvDataRenderingHint var2);

    public void setRenderingHint(IlvDataRenderingHint ilvDataRenderingHint) {
        this.o = ilvDataRenderingHint;
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    public final IlvDataRenderingHint getRenderingHint() {
        return this.o;
    }

    public abstract IlvDataRenderingHint getRenderingHint(IlvDataSet var1, int var2);

    public String computeDataLabel(IlvDataSetPoint ilvDataSetPoint) {
        switch (this.getDataLabelling()) {
            case 1: {
                return ilvDataSetPoint.getDataSet().getDataLabel(ilvDataSetPoint.getIndex());
            }
            case 2: {
                return this.b(ilvDataSetPoint);
            }
            case 4: {
                return this.a(ilvDataSetPoint);
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer("(");
                stringBuffer.append(this.a(ilvDataSetPoint));
                stringBuffer.append(",");
                stringBuffer.append(this.b(ilvDataSetPoint));
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        return new Point(IlvGraphicUtil.toInt(ilvDisplayPoint.getXCoord()), IlvGraphicUtil.toInt(ilvDisplayPoint.getYCoord()));
    }

    public void applyStyles(boolean bl) throws Exception {
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            ((IlvChartRenderer)iterator.next()).applyStyles(bl);
        }
    }

    private void e() {
        boolean bl = this.j.getFlag(2);
        boolean bl2 = this.isVisible() && this.getDataSource().getDataSetCount() >= this.getMinDataSetCount() && this.a() != null;
        this.j.setFlag(2, bl2);
        if (bl != bl2) {
            this.triggerChange(3);
        }
    }

    private final String a(IlvDataSetPoint ilvDataSetPoint) {
        return this.getChart().formatXValue(ilvDataSetPoint.getXData());
    }

    private final String b(IlvDataSetPoint ilvDataSetPoint) {
        return this.getChart().formatYValue(this.getYAxisIdx(), ilvDataSetPoint.getYData());
    }

    static void a(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown chart renderer type: " + n2);
            }
        }
    }

    public static IlvChartRenderer createRenderer(int n2) {
        IlvCompositeChartRenderer ilvCompositeChartRenderer = null;
        switch (n2) {
            case 0: {
                ilvCompositeChartRenderer = new IlvBarChartRenderer();
                break;
            }
            case 1: {
                ilvCompositeChartRenderer = new IlvBarChartRenderer(3);
                break;
            }
            case 17: {
                ilvCompositeChartRenderer = new IlvBarChartRenderer(3);
                ilvCompositeChartRenderer.setStacked100Percent(true);
                break;
            }
            case 2: {
                ilvCompositeChartRenderer = new IlvBarChartRenderer(1);
                break;
            }
            case 3: {
                ilvCompositeChartRenderer = new IlvAreaChartRenderer();
                break;
            }
            case 4: {
                ilvCompositeChartRenderer = new IlvAreaChartRenderer(2);
                break;
            }
            case 19: {
                ilvCompositeChartRenderer = new IlvAreaChartRenderer(2);
                ((IlvAreaChartRenderer)ilvCompositeChartRenderer).setStacked100Percent(true);
                break;
            }
            case 5: {
                ilvCompositeChartRenderer = new IlvPolylineChartRenderer();
                break;
            }
            case 11: {
                ilvCompositeChartRenderer = new IlvPolylineChartRenderer(2);
                break;
            }
            case 18: {
                ilvCompositeChartRenderer = new IlvPolylineChartRenderer(2);
                ((IlvPolylineChartRenderer)ilvCompositeChartRenderer).setStacked100Percent(true);
                break;
            }
            case 6: {
                ilvCompositeChartRenderer = new IlvScatterChartRenderer();
                break;
            }
            case 7: {
                ilvCompositeChartRenderer = new IlvStairChartRenderer();
                break;
            }
            case 14: {
                ilvCompositeChartRenderer = new IlvStairChartRenderer(2);
                break;
            }
            case 20: {
                ilvCompositeChartRenderer = new IlvStairChartRenderer(2);
                ((IlvStairChartRenderer)ilvCompositeChartRenderer).setStacked100Percent(true);
                break;
            }
            case 15: {
                ilvCompositeChartRenderer = new IlvStairChartRenderer(3);
                break;
            }
            case 8: {
                ilvCompositeChartRenderer = new IlvBubbleChartRenderer();
                break;
            }
            case 9: {
                ilvCompositeChartRenderer = new IlvHiLoChartRenderer();
                break;
            }
            case 21: {
                ilvCompositeChartRenderer = new IlvHiLoChartRenderer(1, 2, 80.0);
                break;
            }
            case 22: {
                ilvCompositeChartRenderer = new IlvHiLoChartRenderer(1, 0, 80.0);
                break;
            }
            case 12: {
                ilvCompositeChartRenderer = new IlvHiLoChartRenderer(2, 1, 80.0);
                break;
            }
            case 13: {
                ilvCompositeChartRenderer = new IlvHiLoChartRenderer(3, 1, 80.0);
                break;
            }
            case 10: {
                ilvCompositeChartRenderer = new IlvPieChartRenderer();
                break;
            }
            case 16: {
                ilvCompositeChartRenderer = new IlvComboChartRenderer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown chart type: " + n2);
            }
        }
        return ilvCompositeChartRenderer;
    }

    void a(IlvChartRenderer ilvChartRenderer) {
        this.setRenderingHint(ilvChartRenderer.getRenderingHint());
        this.setAnnotation(ilvChartRenderer.getAnnotation());
        this.setDataLabelLayout(ilvChartRenderer.getDataLabelLayout());
        this.setDataLabelling(ilvChartRenderer.getDataLabelling());
    }

    private void a(IlvDataSet[] ilvDataSetArray, boolean bl, IlvChart ilvChart) {
        IlvStylingSupport ilvStylingSupport;
        IlvChart ilvChart2;
        IlvChart ilvChart3 = ilvChart2 = this.getChart() == null ? ilvChart : this.getChart();
        if (!bl) {
            int n2 = ilvDataSetArray.length;
            while (--n2 >= 0) {
                IlvDataSetStyle.set(ilvChart2, ilvDataSetArray[n2], null);
            }
        } else if (this.getChart().isDynamicStyling() && (ilvStylingSupport = IlvStylingSupport.get(this.getChart())) != null && ilvStylingSupport.hasStyles() && !ilvStylingSupport.isStyling()) {
            try {
                this.applyStyles(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n3 = ilvDataSetArray.length;
        while (--n3 >= 0) {
            IlvDataSet ilvDataSet = ilvDataSetArray[n3];
            if (!(ilvDataSet instanceof IlvLODDataSet)) continue;
            if (bl && this.isViewable()) {
                IlvLODHandler.connect(ilvChart2, (IlvLODDataSet)ilvDataSet);
                continue;
            }
            IlvLODHandler.disconnect(ilvChart2, (IlvLODDataSet)ilvDataSet);
        }
    }

    class DataSourceLST
    implements DataSourceListener,
    Serializable {
        DataSourceLST() {
        }

        public void dataSourceChanged(DataSourceEvent dataSourceEvent) {
            int n2 = dataSourceEvent.getFirstIdx();
            int n3 = dataSourceEvent.getLastIdx();
            if (dataSourceEvent.getType() == 0) {
                IlvChartRenderer.this.dataSetsAdded(n2, n3, dataSourceEvent.getOldDataSets());
                if (IlvChartRenderer.this.getChart() != null) {
                    IlvDataSet[] ilvDataSetArray = new IlvDataSet[n3 - n2 + 1];
                    int n4 = n2;
                    int n5 = 0;
                    while (n4 <= n3) {
                        ilvDataSetArray[n5] = IlvChartRenderer.this.getDataSource().getDataSet(n4);
                        ++n4;
                        ++n5;
                    }
                    IlvChartRenderer.this.a(ilvDataSetArray, true, null);
                }
            } else if (dataSourceEvent.getType() == 1) {
                IlvChartRenderer.this.dataSetsRemoved(n2, n3, dataSourceEvent.getOldDataSets());
                if (IlvChartRenderer.this.getChart() != null) {
                    IlvDataSet[] ilvDataSetArray = new IlvDataSet[n3 - n2 + 1];
                    int n6 = n2;
                    int n7 = 0;
                    while (n6 <= n3) {
                        ilvDataSetArray[n7] = dataSourceEvent.getOldDataSets()[n6];
                        ++n6;
                        ++n7;
                    }
                    IlvChartRenderer.this.a(ilvDataSetArray, false, null);
                }
            }
            IlvChartRenderer.this.e();
            IlvChartRenderer.this.triggerChange(7);
        }
    }
}

