/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

final class IlvChartInteractorManager
implements Serializable {
    private static final String a = "__Ilv_Cursors_Repository";
    private ArrayList b = new ArrayList(5);
    private ArrayList c = new ArrayList(1);
    private IlvChart d;
    private transient IlvChartInteractor e = null;
    private int f;
    private int g;
    private int h;
    private transient InputEventDispatcher i;
    private transient InputEventDispatcher j;
    private transient InputEventDispatcher k;

    public IlvChartInteractorManager(IlvChart ilvChart) {
        this.d = ilvChart;
        this.a();
    }

    private void a() {
        this.i = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                if (ilvChartInteractor.isHandling(mouseEvent.getX(), mouseEvent.getY()) || ilvChartInteractor.isInOperation()) {
                    ilvChartInteractor.processMouseEvent(mouseEvent);
                }
            }
        };
        this.j = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                if (ilvChartInteractor.isHandling(mouseEvent.getX(), mouseEvent.getY()) || ilvChartInteractor.isInOperation()) {
                    ilvChartInteractor.processMouseMotionEvent(mouseEvent);
                }
            }
        };
        this.k = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                ilvChartInteractor.processKeyEvent((KeyEvent)inputEvent);
            }
        };
    }

    public final IlvChart getChart() {
        return this.d;
    }

    public final int getCardinal() {
        return this.b.size();
    }

    private boolean a(IlvChartInteractor ilvChartInteractor) {
        int n2 = ilvChartInteractor.getPriority();
        return n2 == 1 || n2 == 2;
    }

    public synchronized void addInteractor(IlvChartInteractor ilvChartInteractor) throws IllegalArgumentException {
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException();
        }
        if (ilvChartInteractor.getChart() != null) {
            throw new IllegalArgumentException("Interactor already connected to a chart");
        }
        ArrayList arrayList = this.a(ilvChartInteractor) ? this.c : this.b;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object e2 = arrayList.get(i2);
            if (e2 != ilvChartInteractor) continue;
            throw new IllegalArgumentException(ilvChartInteractor + " has already been added");
        }
        arrayList.add(ilvChartInteractor);
        ilvChartInteractor.a(this.d);
        this.a(ilvChartInteractor.a());
    }

    public void addInteractor(String string) throws IllegalArgumentException {
        IlvChartInteractor ilvChartInteractor = IlvChartInteractor.create(string);
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException(string + " cannot be found");
        }
        this.addInteractor(ilvChartInteractor);
    }

    public synchronized void removeInteractor(IlvChartInteractor ilvChartInteractor) throws IllegalArgumentException {
        ArrayList arrayList;
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException();
        }
        ArrayList arrayList2 = arrayList = this.a(ilvChartInteractor) ? this.c : this.b;
        if (arrayList.size() == 0) {
            return;
        }
        ilvChartInteractor.a(null);
        this.b(ilvChartInteractor.a());
        arrayList.remove(ilvChartInteractor);
    }

    public synchronized void removeAllInteractors() {
        while (this.b.size() > 0) {
            IlvChartInteractor ilvChartInteractor = (IlvChartInteractor)this.b.get(this.b.size() - 1);
            ilvChartInteractor.a(null);
            this.b(ilvChartInteractor.a());
            this.b.remove(this.b.size() - 1);
        }
    }

    public synchronized IlvChartInteractor[] getInteractors() {
        IlvChartInteractor[] ilvChartInteractorArray = new IlvChartInteractor[this.b.size()];
        this.b.toArray(ilvChartInteractorArray);
        return ilvChartInteractorArray;
    }

    public void setInteractors(IlvChartInteractor[] ilvChartInteractorArray) {
        this.removeAllInteractors();
        if (ilvChartInteractorArray == null) {
            return;
        }
        for (int i2 = 0; i2 < ilvChartInteractorArray.length; ++i2) {
            this.addInteractor(ilvChartInteractorArray[i2]);
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.h != 0) {
            this.a(mouseEvent, this.j);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.g != 0) {
            this.a(mouseEvent, this.i);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.f != 0) {
            this.a(keyEvent, this.k);
        }
    }

    public void handleExpose(Graphics graphics) {
        if (this.e != null) {
            this.e.handleExpose(graphics);
        }
    }

    void a(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            IlvChartInteractor ilvChartInteractor2 = (IlvChartInteractor)this.b.get(i2);
            if (ilvChartInteractor2 == ilvChartInteractor) continue;
            ilvChartInteractor2.interactionStarted(ilvChartInteractor, mouseEvent);
        }
    }

    private void a(InputEvent inputEvent, InputEventDispatcher inputEventDispatcher) {
        IlvChartInteractor ilvChartInteractor = this.e;
        if (ilvChartInteractor != null) {
            inputEventDispatcher.dispatch(inputEvent, ilvChartInteractor);
            if (!ilvChartInteractor.isInOperation()) {
                this.e = null;
            }
            return;
        }
        boolean bl = this.a(this.c, 1, inputEvent, inputEventDispatcher);
        if (!bl) {
            bl = this.a(this.b, 3, inputEvent, inputEventDispatcher);
        }
        if (!bl) {
            bl = this.a(this.c, 2, inputEvent, inputEventDispatcher);
        }
    }

    private boolean a(List list, int n2, InputEvent inputEvent, InputEventDispatcher inputEventDispatcher) {
        boolean bl = this.getChart().is3D();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IlvChartInteractor ilvChartInteractor = (IlvChartInteractor)list.get(i2);
            if (bl && !ilvChartInteractor.has3DSupport() || ilvChartInteractor.getPriority() != n2) continue;
            inputEventDispatcher.dispatch(inputEvent, ilvChartInteractor);
            if (!inputEvent.isConsumed()) continue;
            if (inputEvent.getID() == 501) {
                this.e = ilvChartInteractor;
            }
            return true;
        }
        return false;
    }

    private void a(long l2) {
        if ((l2 & 0x10L) != 0L) {
            ++this.g;
        }
        if ((l2 & 0x20L) != 0L) {
            ++this.h;
        }
        if ((l2 & 8L) != 0L) {
            ++this.f;
        }
    }

    private void b(long l2) {
        if ((l2 & 0x10L) != 0L) {
            --this.g;
        }
        if ((l2 & 0x20L) != 0L) {
            --this.h;
        }
        if ((l2 & 8L) != 0L) {
            --this.f;
        }
    }

    public static Cursor pushCursor(IlvChart ilvChart, Cursor cursor) {
        Cursor cursor2;
        Cursor cursor3 = cursor2 = ilvChart.isCursorSet() ? ilvChart.getCursor() : null;
        if (cursor == null) {
            return cursor2;
        }
        Vector<Cursor> vector = (Vector<Cursor>)ilvChart.getClientProperty(a);
        if (vector == null) {
            vector = new Vector<Cursor>(5, 5);
            ilvChart.putClientProperty(a, vector);
        }
        vector.addElement(cursor2);
        ilvChart.setCursor(cursor);
        return cursor2;
    }

    public static Cursor popCursor(IlvChart ilvChart) {
        Vector vector = (Vector)ilvChart.getClientProperty(a);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Cursor cursor = ilvChart.isCursorSet() ? ilvChart.getCursor() : null;
        Cursor cursor2 = (Cursor)vector.lastElement();
        vector.removeElementAt(vector.size() - 1);
        ilvChart.setCursor(cursor2);
        return cursor;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a();
    }

    private static interface InputEventDispatcher {
        public void dispatch(InputEvent var1, IlvChartInteractor var2);
    }
}

