/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DSupport;
import ilog.views.chart.IlvChartInteractorManager;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.event.ChartInteractionListener;
import ilog.views.chart.event.IlvListenerList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IlvChartInteractor
implements IlvChart3DSupport,
Serializable {
    private static HashMap a = new HashMap();
    public static final int INTERNAL_HIGH = 1;
    public static final int INTERNAL_LOW = 2;
    public static final int NORMAL = 3;
    private IlvListenerList b;
    private IlvChart c = null;
    private long d;
    private transient boolean e = false;
    private transient boolean f = false;
    private int g;
    private int h;
    private Color i = Color.white;
    private Color j = Color.black;
    private boolean k = false;
    private boolean l = false;

    protected static synchronized void register(String string, Class clazz) {
        a.put(string, clazz);
    }

    public static synchronized String getShortName(Class clazz) {
        String string = null;
        Set set = a.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (clazz != (Class)entry.getValue()) continue;
            string = (String)entry.getKey();
            break;
        }
        return string;
    }

    public static IlvChartInteractor create(String string) {
        IlvChartInteractor ilvChartInteractor = null;
        try {
            ilvChartInteractor = IlvChartInteractor.create(string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ilvChartInteractor;
    }

    public static IlvChartInteractor create(String string, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        IlvChartInteractor ilvChartInteractor = null;
        Class<?> clazz = (Class<?>)a.get(string);
        if (clazz == null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    throw classNotFoundException;
                }
                classNotFoundException.printStackTrace();
            }
        }
        if (clazz != null) {
            try {
                ilvChartInteractor = (IlvChartInteractor)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                if (bl) {
                    throw instantiationException;
                }
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                if (bl) {
                    throw illegalAccessException;
                }
                illegalAccessException.printStackTrace();
            }
        }
        return ilvChartInteractor;
    }

    public static synchronized String[] getRegisteredInteractorsByName() {
        String[] stringArray = new String[a.size()];
        a.keySet().toArray(stringArray);
        return stringArray;
    }

    public IlvChartInteractor() {
        this(0, 0);
    }

    public IlvChartInteractor(int n2, int n3) {
        this.g = n2;
        this.h = n3;
    }

    public int getPriority() {
        return 3;
    }

    public final IlvAxis getXAxis() {
        return this.c.getXAxis();
    }

    public final IlvAxis getYAxis() {
        return this.c.getYAxis(this.g);
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        return this.c.getCoordinateSystem(this.g);
    }

    public final IlvChart getChart() {
        return this.c;
    }

    void a(IlvChart ilvChart) {
        IlvChart ilvChart2 = this.c;
        this.c = ilvChart;
        this.chartConnected(ilvChart2, ilvChart);
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
    }

    final long a() {
        return this.d;
    }

    protected final void enableEvents(long l2) {
        this.d |= l2;
    }

    protected final void disableEvents(long l2) {
        this.d &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final boolean isAborted() {
        return this.e;
    }

    protected void setAborted(boolean bl) {
        this.e = bl;
    }

    public final boolean isInOperation() {
        return this.f;
    }

    protected void setInOperation(boolean bl) {
        this.f = bl;
    }

    public final int getYAxisIndex() {
        return this.g;
    }

    public void setYAxisIndex(int n2) {
        this.g = n2;
    }

    public final int getEventMask() {
        return this.h;
    }

    public void setEventMask(int n2) {
        this.h = n2;
    }

    public Color getGhostColor() {
        return this.j;
    }

    public void setGhostColor(Color color) {
        this.j = color;
    }

    public final Color getXORColor() {
        return this.i;
    }

    public void setXORColor(Color color) {
        this.i = color;
    }

    protected final boolean isAllowDrawGhost() {
        return this.k;
    }

    protected void setAllowDrawGhost(boolean bl) {
        this.k = bl;
    }

    public final boolean isXORGhost() {
        return this.l;
    }

    public void setXORGhost(boolean bl) {
        this.l = bl;
    }

    protected Rectangle getGhostBounds() {
        return null;
    }

    public boolean isHandling(int n2, int n3) {
        if (this.getChart().is3D()) {
            return this.getChart().getChartArea().getDrawRect().contains(n2, n3);
        }
        return this.getChart().getProjector().getShape(this.getCoordinateSystem().getVisibleWindow(), this.getChart().getProjectorRect(), this.getCoordinateSystem()).contains(n2, n3);
    }

    public final IlvDoublePoint getData(MouseEvent mouseEvent) {
        return this.getData(mouseEvent.getX(), mouseEvent.getY());
    }

    public final IlvDoublePoint getData(int n2, int n3) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
        this.getChart().toData(ilvDoublePoints, this.getYAxisIndex());
        return new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public void handleExpose(Graphics graphics) {
        if (this.getChart() == null) {
            return;
        }
        if (this.k) {
            Graphics graphics2 = graphics.create();
            this.initGhostGraphics(graphics2);
            Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.drawGhost(graphics2);
            graphics2.dispose();
        }
    }

    protected final void drawGhost() {
        if (this.getChart() == null || !this.k) {
            return;
        }
        Rectangle rectangle = this.getGhostBounds();
        if (rectangle != null) {
            rectangle.grow(1, 1);
            if (!this.isXORGhost()) {
                this.getChart().getChartArea().repaint(rectangle);
            } else {
                Graphics graphics = this.getChart().getChartArea().getGraphics();
                if (graphics != null) {
                    this.initGhostGraphics(graphics);
                    graphics.setClip(rectangle);
                    this.drawGhost(graphics);
                    graphics.dispose();
                }
            }
        }
    }

    protected void drawGhost(Graphics graphics) {
    }

    protected void initGhostGraphics(Graphics graphics) {
        if (!this.isXORGhost()) {
            graphics.setPaintMode();
        } else {
            graphics.setXORMode(this.getXORColor());
            graphics.setColor(this.getGhostColor());
        }
    }

    public void interactionStarted(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
    }

    protected void startOperation(MouseEvent mouseEvent) {
        this.setAborted(false);
        this.f = true;
        this.getChart().g().a(this, mouseEvent);
    }

    protected void endOperation(MouseEvent mouseEvent) {
        this.setAborted(false);
        this.f = false;
    }

    protected void abort() {
        this.setAborted(true);
        this.f = false;
    }

    protected Cursor setCursor(Cursor cursor) {
        Cursor cursor2 = null;
        cursor2 = cursor != null ? IlvChartInteractorManager.pushCursor(this.c, cursor) : IlvChartInteractorManager.popCursor(this.c);
        return cursor2;
    }

    public final void addChartInteractionListener(ChartInteractionListener chartInteractionListener) {
        if (this.b == null) {
            this.b = new IlvListenerList();
        }
        this.b.add(chartInteractionListener);
    }

    public final void removeChartInteractionListener(ChartInteractionListener chartInteractionListener) {
        if (this.b == null) {
            return;
        }
        this.b.remove(chartInteractionListener);
        if (this.b.getListenerList().length == 0) {
            this.b = null;
        }
    }

    protected final void fireChartInteractionEvent(ChartInteractionEvent chartInteractionEvent) {
        if (this.b == null) {
            return;
        }
        Object[] objectArray = this.b.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ((ChartInteractionListener)objectArray[i2]).interactionPerformed(chartInteractionEvent);
        }
    }

    public boolean has3DSupport() {
        return true;
    }
}

