/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.record;

import hk.com.realink.feed.toolkit.RKObject;
import hk.com.realink.feed.toolkit.RKResponse;
import hk.com.realink.feed.toolkit.RKResult;
import hk.com.realink.feed.toolkit.record.RK_NOTIFIER;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class WNT_RESP
extends RKResponse {
    private RKResult errorCode = new RKResult();
    private RK_NOTIFIER notifier = new RK_NOTIFIER();
    private BitSet dataFlags = new BitSet();
    private ArrayList dataList = new ArrayList();

    public WNT_RESP() {
        this.setRKType(8194);
    }

    public BitSet getDataFlags() {
        return this.dataFlags;
    }

    public void setDataFlags(BitSet m_dataFlags) {
        this.dataFlags = m_dataFlags;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
            this.errorCode = (RKResult)in.readObject();
            if (this.getError().getValue() == 0) {
                this.notifier = new RK_NOTIFIER(in.readInt());
                this.dataFlags = (BitSet)in.readObject();
                this.dataList.addAll(Arrays.asList((Object[])in.readObject()));
            }
        }
        catch (IOException ioexception) {
            System.out.println("Error reading " + this.getClass().getName() + " : " + ioexception);
            throw ioexception;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            super.writeExternal(out);
            out.writeObject(this.errorCode);
            if (this.getError().getValue() == 0) {
                out.writeInt(this.notifier.getValue());
                out.writeObject(this.dataFlags);
                out.writeObject(this.getRKDataBatch());
            }
        }
        catch (IOException ioexception) {
            System.out.println("Error writing " + this.getClass().getName() + " : " + ioexception);
            throw ioexception;
        }
    }

    public RKResult getError() {
        return this.errorCode;
    }

    public void setError(RKResult rkResult) {
        this.errorCode = rkResult;
    }

    public RK_NOTIFIER getRkNotifier() {
        return this.notifier;
    }

    public void setRkNotifier(RK_NOTIFIER m_notifier) {
        this.notifier = m_notifier;
    }

    public void addRKDataBatch(RKObject rkObject) {
        this.dataList.add(rkObject);
    }

    public Object[] getRKDataBatch() {
        return this.dataList.toArray(new Object[0]);
    }

    private String getParamString() {
        String s2 = "";
        s2 = s2 + "\n   errorCode:           " + this.errorCode;
        if (this.getError().getValue() == 0) {
            s2 = s2 + "\n   dataList:                " + this.dataList;
        }
        return s2;
    }

    public String paramString(boolean flag) {
        return (flag ? "\nWNT_RESP\n{" : "") + super.paramString(false) + this.getParamString() + (flag ? "\n}" : "");
    }

    public String paramString() {
        return this.paramString(true);
    }
}

