/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

import hk.com.realink.feed.toolkit.RKDebug;
import hk.com.realink.feed.toolkit.pool.JDCConnectionPool;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDCConnectionDriver
implements Driver {
    public static final String URL_PREFIX = "jdbc:jdc:";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private JDCConnectionPool pool;

    public JDCConnectionDriver(String driver, String url, String user, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        RKDebug.output("create JDCConnectionDriver object");
        DriverManager.registerDriver(this);
        Class.forName(driver).newInstance();
        this.pool = new JDCConnectionPool(url, user, password);
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (!url.startsWith(URL_PREFIX)) {
            return null;
        }
        return this.pool.getConnection();
    }

    public int getConnectionSize() {
        return this.pool.getConnectionSize();
    }

    public Connection getConnection() throws SQLException {
        return this.pool.getConnection();
    }

    public boolean acceptsURL(String url) {
        return url.startsWith(URL_PREFIX);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String str, Properties props) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

