/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

import hk.com.realink.feed.toolkit.pool.JDCConnectionPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class JDCConnection
implements Connection {
    private JDCConnectionPool pool;
    private Connection conn;
    private boolean inuse;
    private long timestamp;

    public JDCConnection(Connection conn, JDCConnectionPool pool) {
        this.conn = conn;
        this.pool = pool;
        this.inuse = false;
        this.timestamp = 0L;
    }

    public synchronized boolean lease() {
        if (this.inuse) {
            return false;
        }
        this.inuse = true;
        this.timestamp = System.currentTimeMillis();
        return true;
    }

    public boolean validate() {
        try {
            this.conn.getMetaData();
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public boolean inUse() {
        return this.inuse;
    }

    public long getLastUse() {
        return this.timestamp;
    }

    public void close() throws SQLException {
        this.pool.returnConnection(this);
    }

    protected void expireLease() {
        this.inuse = false;
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int antoGeneratedKeys) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int p1, int p2, int p3) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql, int p1, int p2, int p3) throws SQLException {
        return null;
    }

    public Statement createStatement(int p1, int p2, int p3) throws SQLException {
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }
}

