/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import omni.obj.client.Dataizable;
import omni.obj.client.DealItem;

public class DealUser
implements Dataizable {
    public String insId = "";
    public int dealPrice = 0;
    public int dealQty = 0;
    public int seqNum = 0;
    public ArrayList dealItemList = new ArrayList();
    public long timeStamp = 0L;
    public byte state = 0;
    public static final byte STATE_ACIVE = 1;
    public static final byte STATE_RECTIFIED = 2;
    public static final byte STATE_DELETED = 3;
    public static final byte STATE_TRANSFERRED = 4;

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.insId);
        dataOutput.writeInt(this.dealPrice);
        dataOutput.writeInt(this.dealQty);
        dataOutput.writeInt(this.seqNum);
        int n2 = this.dealItemList.size();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ((DealItem)this.dealItemList.get(i2)).writeExternal(dataOutput);
        }
        dataOutput.writeLong(this.timeStamp);
        dataOutput.writeByte(this.state);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.insId = dataInput.readUTF();
        this.dealPrice = dataInput.readInt();
        this.dealQty = dataInput.readInt();
        this.seqNum = dataInput.readInt();
        int n2 = dataInput.readInt();
        this.dealItemList = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            DealItem dealItem = new DealItem();
            dealItem.readExternal(dataInput);
            this.dealItemList.add(dealItem);
        }
        this.timeStamp = dataInput.readLong();
        this.state = dataInput.readByte();
    }

    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("timeStamp=").append(this.timeStamp).append(", insId=").append(this.insId);
        stringBuilder.append(", dealPrice=").append(this.dealPrice);
        stringBuilder.append(", dealQuantity=").append(this.dealQty);
        stringBuilder.append(", seqNo=").append(this.seqNum).append(", state=").append(this.state);
        int n2 = this.dealItemList.size();
        if (n2 > 0) {
            stringBuilder.append("\n");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(((DealItem)this.dealItemList.get(i2)).toString());
                if (i2 >= n2 - 1) continue;
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

