/*
 * Decompiled with CFR 0.152.
 */
package omni.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.TreeMap;
import omni.db.RecUnderlyingItem;
import omni.obj.client.Dataizable;
import omni.obj.client.STATUS;
import omni.obj.client.Series;

public class RecMarketItem
implements Dataizable {
    public Series series = new Series();
    public String market = "";
    public String name = "";
    public TreeMap comMap = new TreeMap();

    public RecMarketItem() {
        this.series.country = (byte)12;
    }

    public RecMarketItem(int n2, String string, String string2) {
        this.series.country = (byte)12;
        this.series.market = (byte)n2;
        this.market = string;
        this.name = string2;
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.series.readExternal(dataInput);
        this.market = dataInput.readUTF();
        this.name = dataInput.readUTF();
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            RecUnderlyingItem recUnderlyingItem = new RecUnderlyingItem();
            recUnderlyingItem.readExternal(dataInput);
            this.comMap.put(recUnderlyingItem.series.getUnderlyingKey(), recUnderlyingItem);
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        this.series.writeExternal(dataOutput);
        dataOutput.writeUTF(this.market);
        dataOutput.writeUTF(this.name);
        dataOutput.writeInt(this.comMap.size());
        for (RecUnderlyingItem recUnderlyingItem : this.comMap.values()) {
            recUnderlyingItem.writeExternal(dataOutput);
        }
    }

    public RecUnderlyingItem getRecUnderlyingItem(Series series2) {
        return (RecUnderlyingItem)this.comMap.get(series2.getUnderlyingKey());
    }

    public RecUnderlyingItem putRecUnderlyingItem(Series series2, RecUnderlyingItem recUnderlyingItem) {
        return this.comMap.put(series2.getUnderlyingKey(), recUnderlyingItem);
    }

    public RecUnderlyingItem[] getRecUnderlyingItems() {
        return this.comMap.values().toArray(new RecUnderlyingItem[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[RecMarketItem]");
        stringBuilder.append(STATUS.LF);
        stringBuilder.append("market=").append(this.market).append(", name=").append(this.name).append(STATUS.LF);
        stringBuilder.append(this.series.toString()).append(STATUS.LF);
        for (RecUnderlyingItem recUnderlyingItem : this.comMap.values()) {
            stringBuilder.append(recUnderlyingItem.toString()).append(STATUS.LF);
        }
        stringBuilder.append("[RecMarketItem]");
        return stringBuilder.toString();
    }
}

