/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.util;

import hk.com.realink.quot.ams.StaticRoot;
import hk.com.realink.quot.mdf.XsWnt;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import leaseLineQuote.f;
import leaseLineQuote.multiWindows.GUI.LanguageControl;

public class StockUtil {
    private static final String BundleName = "StockTypeNTradeStatus";
    private static final Lock stLock = new ReentrantLock();
    private static final Map<String, String> ChiSctyType = new HashMap<String, String>();
    private static final Map<String, String> EngSctyType = new HashMap<String, String>();

    private StockUtil() {
    }

    public static final float calPercentFlut(float f2, float f3) {
        float f4;
        float f5 = 0.0f;
        float f6 = f2 + f3;
        if (f4 > 0.0f) {
            f5 = (f2 - f3) / (f6 / 2.0f) * 100.0f;
        }
        return f5;
    }

    public static final float calDollarChange(float f2, float f3) {
        return f2 - f3;
    }

    public static final float calPercentChange(float f2, float f3) {
        float f4 = 0.0f;
        if (f3 > 0.0f) {
            f4 = (f2 - f3) / f3 * 100.0f;
        }
        return f4;
    }

    public static final float calAverage(float f2, float f3) {
        if (f3 > 0.0f) {
            return f2 / f3;
        }
        return 0.0f;
    }

    public static boolean isInlineWarrants(XsWnt xsWnt) {
        return "WRNT".equals(xsWnt.instrumentType) && xsWnt.productType == 15 && xsWnt.warrantType == 'X';
    }

    public static boolean isInlineWarrants(StaticRoot staticRoot) {
        if (staticRoot != null && staticRoot.xsGeneral instanceof XsWnt) {
            return StockUtil.isInlineWarrants((XsWnt)staticRoot.xsGeneral);
        }
        return false;
    }

    private static final String getSctyType(String string) {
        Map<String, String> map = LanguageControl.getLanguageID() == 0 ? ChiSctyType : EngSctyType;
        String string2 = map.get(string);
        if (string2 == null && (string2 = StockUtil._getSctyType(string)) != null) {
            stLock.lock();
            try {
                map.put(string, string2);
            }
            finally {
                stLock.unlock();
            }
        }
        return string2;
    }

    private static final String _getSctyType(String string) {
        return LanguageControl.getLanguageString(BundleName, string);
    }

    public static final String mapSctyType(StaticRoot staticRoot) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StockUtil._mapSctyType(staticRoot));
        boolean bl2 = staticRoot.xsGeneral.casFlag == 'Y';
        boolean bl3 = bl = staticRoot.xsGeneral.vcmFlag == 'Y';
        if (bl2) {
            if (bl) {
                stringBuilder.append(" CV");
            } else {
                stringBuilder.append(" C");
            }
        } else if (bl) {
            stringBuilder.append(" V");
        }
        return stringBuilder.toString();
    }

    private static final String _mapSctyType(StaticRoot object) {
        String string = ((StaticRoot)object).xsGeneral.instrumentType;
        if ("WRNT".equalsIgnoreCase(string)) {
            if (StockUtil.isInlineWarrants((StaticRoot)object)) {
                return StockUtil.getSctyType("INLINE");
            }
            object = ((StaticRoot)object).xsGeneral.sctyShortName;
            if (((String)object).length() < 3 || ((String)object).charAt(2) != '#') {
                return StockUtil.getSctyType("WRNT");
            }
            return StockUtil.getSctyType("CBBC");
        }
        return StockUtil.getSctyType(string);
    }

    public static final Color mapTradingStatusColor(String string) {
        if (string.equals("OI")) {
            return f.aA;
        }
        if (string.equals("NC")) {
            return f.aA;
        }
        if (string.equals("MA")) {
            return f.aA;
        }
        if (string.equals("BL")) {
            return f.aC;
        }
        if (string.equals("CT")) {
            return f.aB;
        }
        if (string.equals("CL")) {
            return f.aC;
        }
        if (string.equals("OC")) {
            return f.aA;
        }
        if (string.equals("EI")) {
            return f.aA;
        }
        if (string.equals("DC")) {
            return f.aC;
        }
        if (string.equals("NO")) {
            return f.aC;
        }
        return f.aA;
    }

    public static final String mapTradingStatus(String string) {
        return StockUtil.getSctyType(string);
    }

    public static final String mapCallPut(char c2) {
        switch (c2) {
            case 'C': {
                return StockUtil.getSctyType("Call");
            }
            case 'P': {
                return StockUtil.getSctyType("Put");
            }
        }
        return StockUtil.getSctyType("Other");
    }
}

