/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import leaseLineQuote.multiWindows.proxy.ConnectionSetting;

public class ImageUtil {
    private static final Map<ImageIcon, Map<Dimension, WeakReference<ImageIcon>>> cache = new HashMap<ImageIcon, Map<Dimension, WeakReference<ImageIcon>>>();
    private static final ReentrantReadWriteLock cacheRW = new ReentrantReadWriteLock();
    private static final Lock cacheR = cacheRW.readLock();
    private static final Lock cacheW = cacheRW.writeLock();
    private static final ReentrantLock resizeCacheLock = new ReentrantLock();

    private static final ImageIcon getCachedImageIcon(ImageIcon object, int n2, int n3) {
        try {
            Dimension dimension;
            Object object2;
            cacheR.lock();
            Map<Dimension, WeakReference<ImageIcon>> map = cache.get(object);
            if (map != null && (object2 = map.get(dimension = new Dimension(n2, n3))) != null) {
                if ((object2 = (ImageIcon)((Reference)object2).get()) == null) {
                    map.remove(dimension);
                    if (map.size() == 0) {
                        cache.remove(object);
                    }
                }
                object = object2;
                cacheR.unlock();
                return object;
            }
            ImageIcon imageIcon = null;
            cacheR.unlock();
            return imageIcon;
        }
        catch (Throwable throwable) {
            cacheR.unlock();
            throw throwable;
        }
    }

    private static final void setCachedImageIcon(ImageIcon imageIcon, int n2, int n3, ImageIcon imageIcon2) {
        try {
            cacheW.lock();
            Map<Dimension, WeakReference<ImageIcon>> map = cache.get(imageIcon);
            if (map == null) {
                map = new HashMap<Dimension, WeakReference<ImageIcon>>();
                cache.put(imageIcon, map);
            }
            map.put(new Dimension(n2, n3), new WeakReference<ImageIcon>(imageIcon2));
            return;
        }
        finally {
            cacheW.unlock();
        }
    }

    public static final ImageIcon resizeImageCache(ImageIcon imageIcon, int n2, int n3) {
        if (imageIcon == null) {
            return null;
        }
        ImageIcon imageIcon2 = ImageUtil.getCachedImageIcon(imageIcon, n2, n3);
        if (imageIcon2 == null) {
            try {
                resizeCacheLock.lock();
                imageIcon2 = ImageUtil.getCachedImageIcon(imageIcon, n2, n3);
                if (imageIcon2 == null) {
                    imageIcon2 = ImageUtil.resizeImage(imageIcon, n2, n3);
                    ImageUtil.setCachedImageIcon(imageIcon, n2, n3, imageIcon2);
                }
            }
            finally {
                resizeCacheLock.unlock();
            }
        }
        return imageIcon2;
    }

    public static final ImageIcon resizeImage(ImageIcon imageIcon, int n2, int n3) {
        n2 = Math.max(1, n2);
        n3 = Math.max(1, n3);
        double d2 = (double)n2 / (double)imageIcon.getIconWidth();
        double d3 = (double)n3 / (double)imageIcon.getIconHeight();
        double d4 = Math.min(d2, d3);
        n2 = Math.max((int)Math.round((double)imageIcon.getIconWidth() * d4), 1);
        n3 = Math.max((int)Math.round((double)imageIcon.getIconHeight() * d4), 1);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, n2, n3, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static final BufferedImage resizeImage(BufferedImage bufferedImage, int n2, int n3) {
        n2 = Math.max(1, n2);
        n3 = Math.max(1, n3);
        double d2 = (double)n2 / (double)bufferedImage.getWidth();
        double d3 = (double)n3 / (double)bufferedImage.getHeight();
        double d4 = Math.min(d2, d3);
        n2 = Math.max((int)Math.round((double)bufferedImage.getWidth() * d4), 1);
        n3 = Math.max((int)Math.round((double)bufferedImage.getHeight() * d4), 1);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static final BufferedImage getImageIcon2BufferedImage(ImageIcon object) {
        object = ((ImageIcon)object).getImage();
        BufferedImage bufferedImage = new BufferedImage(((Image)object).getWidth(null), ((Image)object).getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)object, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(ImageIcon object, int n2, int n3) {
        if (object != null && ((ImageIcon)object).getImageLoadStatus() == 8) {
            BufferedImage bufferedImage = new BufferedImage(((ImageIcon)object).getIconWidth(), ((ImageIcon)object).getIconHeight(), 2);
            bufferedImage.getGraphics().drawImage(((ImageIcon)object).getImage(), 0, 0, ((ImageIcon)object).getIconWidth(), ((ImageIcon)object).getIconHeight(), null);
            double d2 = (float)n2 / (float)((ImageIcon)object).getIconWidth();
            double d3 = (float)n3 / (float)((ImageIcon)object).getIconHeight();
            double d4 = Math.min(d2, d3);
            System.out.println("scale=" + d4);
            if (d4 != 1.0) {
                object = new AffineTransform();
                double d5 = d4;
                ((AffineTransform)object).scale(d5, d5);
                object = new AffineTransformOp((AffineTransform)object, 2);
                bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
            }
            return bufferedImage;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static Image getImage(String string) {
        BufferedImage bufferedImage;
        block18: {
            InputStream inputStream = null;
            bufferedImage = null;
            Object object = null;
            URL uRL = new URL(string);
            switch (ConnectionSetting.getProxySetting()) {
                case 0: {
                    object = uRL.openConnection();
                    break;
                }
                case 1: {
                    object = uRL.openConnection(Proxy.NO_PROXY);
                    break;
                }
                case 2: {
                    object = new InetSocketAddress(ConnectionSetting.getSocksHost(), ConnectionSetting.getSocksPort());
                    object = new Proxy(Proxy.Type.SOCKS, (SocketAddress)object);
                    object = uRL.openConnection((Proxy)object);
                    break;
                }
                case 3: {
                    object = new InetSocketAddress(ConnectionSetting.getHttpProxyHost(), ConnectionSetting.getHttpProxyPort());
                    object = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
                    object = uRL.openConnection((Proxy)object);
                }
            }
            if (object != null) {
                ((URLConnection)object).setReadTimeout(3000);
                ((URLConnection)object).setConnectTimeout(3000);
                ((URLConnection)object).setDoOutput(false);
                inputStream = ((URLConnection)object).getInputStream();
                if (inputStream != null) {
                    bufferedImage = ImageIO.read(inputStream);
                }
            }
            System.out.println("(bi!=null):" + (bufferedImage != null) + "," + string);
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            break block18;
            catch (Exception exception) {
                try {
                    System.out.println("ReadImageErr(" + string + ") - " + exception);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {}
            }
        }
        return bufferedImage;
    }
}

