/*
 * Decompiled with CFR 0.152.
 */
package isurewin.bss.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;

public class Spinner
extends JPanel {
    private int orientation = 1;
    private BasicArrowButton upButton;
    private BasicArrowButton downButton;
    private JPanel btnPane;
    private Dimension size = new Dimension(18, 18);

    public Spinner() {
        this.createComponents();
    }

    public Spinner(int n2) {
        this.orientation = n2;
        this.createComponents();
    }

    public Spinner(int n2, Dimension dimension) {
        this.orientation = n2;
        this.size = dimension;
        this.createComponents();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.upButton.isEnabled() && this.downButton.isEnabled();
    }

    protected void createComponents() {
        this.btnPane = new JPanel();
        if (this.orientation == 1) {
            this.btnPane.setLayout(new GridLayout(2, 1));
            this.upButton = new BasicArrowButton(1);
            this.downButton = new BasicArrowButton(5);
            this.btnPane.add(this.upButton);
            this.btnPane.add(this.downButton);
        } else if (this.orientation == 0) {
            this.btnPane.setLayout(new GridLayout(1, 2));
            this.upButton = new BasicArrowButton(1);
            this.downButton = new BasicArrowButton(5);
            this.btnPane.add(this.downButton);
            this.btnPane.add(this.upButton);
        }
        this.btnPane.setPreferredSize(this.size);
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JPanel getBtnPane() {
        return this.btnPane;
    }

    public JPanel getSpinnerPane(JComponent jComponent) {
        this.setLayout(new BorderLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)jComponent, "Center");
        Spinner spinner = this;
        spinner.add((Component)spinner.btnPane, "East");
        this.setBorder(BorderFactory.createEtchedBorder());
        return this;
    }

    public void setActionListener(ActionListener actionListener) {
        this.upButton.addActionListener(actionListener);
        this.downButton.addActionListener(actionListener);
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.upButton.addMouseListener(mouseListener);
        this.downButton.addMouseListener(mouseListener);
    }
}

