/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.histnews.history;

import hk.com.realink.histnews.history.b;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class HistRecord
implements Serializable {
    static final long serialVersionUID = -1609752280599431232L;
    public static final int TYPE_DAY = 1;
    public static final int TYPE_WEEK = 2;
    public static final int TYPE_MONTH = 3;
    public static final int TYPE_INTERDAY = 8;
    public static final int LEVEL_ROOT = 4;
    public static final int LEVEL_TYPE = 5;
    public static final int LEVEL_POINT = 6;
    public static final int LEVEL_UNIT = 7;
    public static final int ADD_UNSUPPORT = -2;
    public static final int ADD_FULL = -1;
    public static final int ADD_RETRY = 0;
    public static final int ADD_SUCCESS = 1;
    public static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public String companyCode = "";
    public float open = 0.0f;
    public float close = 0.0f;
    public float high = 0.0f;
    public float low = 0.0f;
    public long maxTurnover = 0L;
    public long date = 0L;
    private int type = 1;
    private int level = 7;
    private ArrayList histRecordList = null;
    private HashMap daysHashMap = null;
    private int pointLevelIndex = -1;
    private int amount = 1;
    private b interRange = null;

    private HistRecord() {
    }

    public HistRecord(String string) {
        this.companyCode = string;
    }

    public HistRecord(String string, int n2) {
        this.companyCode = string;
        this.level = n2;
    }

    public boolean isInValidDay() {
        return this.open == 0.0f && this.close == 0.0f;
    }

    private void setPointLevelIndex(int n2) {
        this.pointLevelIndex = n2;
    }

    public int getPointLevelIndex() {
        return this.pointLevelIndex;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    private void setLevel(int n2) {
        this.level = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public static Calendar getCalendar(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l2));
        return calendar;
    }

    public HistRecord getBeginHistRecord() {
        if (this.histRecordList == null) {
            return null;
        }
        return (HistRecord)this.histRecordList.get(0);
    }

    public HistRecord getLastHistRecord() {
        if (this.histRecordList == null) {
            return null;
        }
        int n2 = this.histRecordList.size() - 1;
        if (n2 >= 0) {
            return (HistRecord)this.histRecordList.get(n2);
        }
        return null;
    }

    public static HistRecord createMaxHistRecord(int n2, int n3, HistRecord[] histRecordArray) {
        HistRecord histRecord = new HistRecord(histRecordArray[0].companyCode, histRecordArray[0].level);
        while (n2 <= n3) {
            if (histRecordArray[n2].high > histRecord.high) {
                histRecord.high = histRecordArray[n2].high;
            }
            if (histRecordArray[n2].low < histRecord.low && histRecordArray[n2].low != 0.0f || histRecord.low == 0.0f) {
                histRecord.low = histRecordArray[n2].low;
            }
            if (histRecordArray[n2].open > histRecord.high) {
                histRecord.high = histRecordArray[n2].open;
            }
            if (histRecordArray[n2].close > histRecord.high) {
                histRecord.high = histRecordArray[n2].close;
            }
            if (histRecordArray[n2].open < histRecord.low && histRecordArray[n2].open != 0.0f) {
                histRecord.low = histRecordArray[n2].open;
            }
            if (histRecordArray[n2].close < histRecord.low && histRecordArray[n2].close != 0.0f) {
                histRecord.low = histRecordArray[n2].close;
            }
            if (histRecordArray[n2].maxTurnover > histRecord.maxTurnover) {
                histRecord.maxTurnover = histRecordArray[n2].maxTurnover;
            }
            ++n2;
        }
        return histRecord;
    }

    private Collection getHistRecords() {
        return this.histRecordList;
    }

    public HistRecord[] toArray() {
        HistRecord[] histRecordArray = this.histRecordList.toArray(new HistRecord[0]);
        return histRecordArray;
    }

    public ArrayList getList() {
        return this.histRecordList;
    }

    public Object clone() {
        HistRecord histRecord = new HistRecord(this.companyCode, this.type);
        new HistRecord(this.companyCode, this.type).date = this.date;
        histRecord.close = this.close;
        histRecord.open = this.open;
        histRecord.high = this.high;
        histRecord.low = this.low;
        histRecord.maxTurnover = this.maxTurnover;
        return histRecord;
    }

    private void setAmount(int n2) {
        if (n2 > 0) {
            this.amount = n2;
        }
    }

    public HistRecord getTypeHistRecord(int n2, int n3) {
        Iterator iterator = this.histRecordList.iterator();
        HistRecord histRecord = new HistRecord(this.companyCode, 5);
        histRecord.setType(n2);
        histRecord.setAmount(n3);
        HistRecord histRecord2 = null;
        int n4 = -1;
        int n5 = 0;
        HistRecord histRecord3 = null;
        while (iterator.hasNext()) {
            if (n4 != 0) {
                histRecord3 = (HistRecord)iterator.next();
            }
            if (n4 == -1 || n4 == 0) {
                histRecord2 = (HistRecord)histRecord3.clone();
                ((HistRecord)histRecord3.clone()).maxTurnover = 0L;
                histRecord2.setPointLevelIndex(n5++);
                histRecord2.setType(n2);
                histRecord2.setLevel(6);
                histRecord2.setAmount(n3);
                histRecord.addHistRecord(histRecord2);
            }
            histRecord3.setPointLevelIndex(histRecord2.getPointLevelIndex());
            n4 = histRecord2.addHistRecord(histRecord3);
            histRecord.addDayIndex(histRecord3);
        }
        return histRecord;
    }

    public int getPointLevelIndex(int n2, int n3, int n4) {
        long l2;
        HistRecord histRecord;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(0L));
        calendar.set(n2, n3 - 1, n4, 0, 0, 0);
        n2 = -1;
        if (this.level == 5 && (histRecord = (HistRecord)this.daysHashMap.get(new Long(l2 = calendar.getTime().getTime()))) != null) {
            n2 = histRecord.getPointLevelIndex();
        }
        return n2;
    }

    private void addDayIndex(HistRecord histRecord) {
        if (this.level == 5) {
            if (this.daysHashMap == null) {
                this.daysHashMap = new HashMap(701);
            }
            this.daysHashMap.put(histRecord.date, histRecord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addHistRecord(HistRecord histRecord) {
        if (this.histRecordList == null) {
            this.histRecordList = new ArrayList();
        }
        boolean bl = true;
        boolean bl2 = false;
        if (this.level == 4) {
            if (histRecord.type == 1 && histRecord.level == 7) {
                this.histRecordList.add(histRecord);
                bl = true;
            } else {
                bl2 = true;
            }
        } else if (this.level == 5) {
            if (histRecord.level == 6) {
                this.histRecordList.add(histRecord);
                bl = true;
            } else {
                bl2 = true;
            }
        } else if (this.level == 6) {
            if (histRecord.type == 1) {
                if (this.type == 1) {
                    if (this.histRecordList.size() >= 1 * this.amount) {
                        return -1;
                    }
                    this.histRecordList.add(histRecord);
                    if (this.histRecordList.size() >= 1 * this.amount) {
                        bl = false;
                    }
                } else if (this.type == 2) {
                    if (this.histRecordList.size() >= 5 * this.amount) {
                        return -1;
                    }
                    this.maxTurnover += histRecord.maxTurnover;
                    this.histRecordList.add(histRecord);
                    if (this.histRecordList.size() >= 5 * this.amount) {
                        bl = false;
                    }
                } else if (this.type == 3) {
                    if (this.histRecordList.size() == 0) {
                        this.maxTurnover += histRecord.maxTurnover;
                        this.histRecordList.add(histRecord);
                    } else {
                        Serializable serializable = (HistRecord)this.histRecordList.get(0);
                        Calendar calendar = HistRecord.getCalendar(((HistRecord)serializable).date);
                        serializable = HistRecord.getCalendar(histRecord.date);
                        if (calendar.get(1) != ((Calendar)serializable).get(1) || calendar.get(2) != ((Calendar)serializable).get(2)) return 0;
                        this.maxTurnover += histRecord.maxTurnover;
                        this.histRecordList.add(histRecord);
                    }
                } else if (this.type == 8) {
                    int n2 = this.histRecordList.size();
                    if (this.amount == 1 && n2 > 0) {
                        return -1;
                    }
                    if (n2 > 0) {
                        Calendar calendar = HistRecord.getCalendar(histRecord.date);
                        if (!this.interRange.isInRange(calendar)) return 0;
                        this.maxTurnover += histRecord.maxTurnover;
                    } else if (this.amount > 1) {
                        this.interRange = new b(this.amount);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(new Date(histRecord.date));
                        this.interRange.setTime(calendar);
                    }
                    this.histRecordList.add(histRecord);
                    if (this.amount == 1 && ++n2 > 0) {
                        bl = false;
                    }
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            System.out.println("HistRecord unsupport operation type " + this.type + " level : " + this.level);
            return -2;
        }
        if (this.open == 0.0f) {
            this.open = histRecord.open;
        }
        if (histRecord.close > 0.0f) {
            this.close = histRecord.close;
        }
        this.date = this.interRange != null ? this.interRange.endTime.getTimeInMillis() : histRecord.date;
        if (histRecord.high > this.high) {
            this.high = histRecord.high;
        }
        if ((histRecord.low < this.low || this.low <= 0.0f) && histRecord.low > 0.0f) {
            this.low = histRecord.low;
        }
        if (histRecord.maxTurnover > this.maxTurnover) {
            this.maxTurnover = histRecord.maxTurnover;
        }
        if (!bl) return -1;
        return 1;
    }

    public static void setDataTimeFormat(String string) {
        dateTimeFormatter = new SimpleDateFormat(string);
    }

    public String toDateTimeString() {
        return dateTimeFormatter.format(new Date(this.date));
    }

    public String toString() {
        String string = this.toDateTimeString();
        return "companyCode = " + this.companyCode + " open = " + this.open + " close = " + this.close + " high = " + this.high + " low = " + this.low + " maxTurnover = " + this.maxTurnover + " date = " + string + " type = " + this.type + " pointLevelIndex = " + this.pointLevelIndex;
    }
}

