/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.record;

import hk.com.realink.feed.toolkit.RKObject;
import hk.com.realink.feed.toolkit.RKResponse;
import hk.com.realink.feed.toolkit.RKResult;
import hk.com.realink.feed.toolkit.record.RK_NOTIFIER;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class WNT_RESP
extends RKResponse {
    private RKResult errorCode = new RKResult();
    private RK_NOTIFIER notifier = new RK_NOTIFIER();
    private BitSet dataFlags = new BitSet();
    private ArrayList dataList = new ArrayList();

    public WNT_RESP() {
        this.setRKType(8194);
    }

    public BitSet getDataFlags() {
        return this.dataFlags;
    }

    public void setDataFlags(BitSet bitSet) {
        this.dataFlags = bitSet;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
            this.errorCode = (RKResult)objectInput.readObject();
            if (this.getError().getValue() == 0) {
                this.notifier = new RK_NOTIFIER(objectInput.readInt());
                this.dataFlags = (BitSet)objectInput.readObject();
                this.dataList.addAll(Arrays.asList((Object[])objectInput.readObject()));
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error reading " + this.getClass().getName() + " : " + iOException);
            throw iOException;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            super.writeExternal(objectOutput);
            objectOutput.writeObject(this.errorCode);
            if (this.getError().getValue() == 0) {
                objectOutput.writeInt(this.notifier.getValue());
                objectOutput.writeObject(this.dataFlags);
                objectOutput.writeObject(this.getRKDataBatch());
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error writing " + this.getClass().getName() + " : " + iOException);
            throw iOException;
        }
    }

    @Override
    public RKResult getError() {
        return this.errorCode;
    }

    public void setError(RKResult rKResult) {
        this.errorCode = rKResult;
    }

    public RK_NOTIFIER getRkNotifier() {
        return this.notifier;
    }

    public void setRkNotifier(RK_NOTIFIER rK_NOTIFIER) {
        this.notifier = rK_NOTIFIER;
    }

    @Override
    public void addRKDataBatch(RKObject rKObject) {
        this.dataList.add(rKObject);
    }

    public Object[] getRKDataBatch() {
        return this.dataList.toArray(new Object[0]);
    }

    private String getParamString() {
        String string = "";
        string = string + "\n   errorCode:           " + this.errorCode;
        if (this.getError().getValue() == 0) {
            string = string + "\n   dataList:                " + this.dataList;
        }
        return string;
    }

    @Override
    public String paramString(boolean bl) {
        return (bl ? "\nWNT_RESP\n{" : "") + super.paramString(false) + this.getParamString() + (bl ? "\n}" : "");
    }

    @Override
    public String paramString() {
        return this.paramString(true);
    }
}

