/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.record;

import hk.com.realink.feed.toolkit.RKObject;
import hk.com.realink.feed.toolkit.data.Tt2;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class SCTY_TT_RAW
extends RKObject {
    static final long serialVersionUID = 8285579041963922123L;
    private String companyCode = "0";
    private String companyShortName = "";
    private int lotSize = 0;
    private Tt2[] tts = null;
    private transient boolean isSecWrStream = false;
    public static boolean isSecRdStream = false;

    public SCTY_TT_RAW() {
    }

    public SCTY_TT_RAW(String string) {
        this.companyCode = string;
    }

    public void setSecWrStream() {
        this.isSecWrStream = true;
    }

    public void setTtArray(Tt2[] tt2Array) {
        this.tts = tt2Array;
    }

    public Tt2[] getTtArray() {
        return this.tts;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyShortName(String string) {
        this.companyShortName = string;
    }

    public String getCompanyShortName() {
        return this.companyShortName;
    }

    public void setLotSize(int n2) {
        this.lotSize = n2;
    }

    public int getLotSize() {
        return this.lotSize;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
            this.companyCode = objectInput.readUTF();
            this.companyShortName = objectInput.readUTF();
            this.lotSize = objectInput.readInt();
            int n2 = objectInput.readInt();
            ArrayList<Tt2> arrayList = new ArrayList<Tt2>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Tt2 tt2 = new Tt2();
                new Tt2().sctyCode = Integer.parseInt(this.companyCode);
                tt2.publicTradeType = objectInput.readChar();
                tt2.rejectFlag = objectInput.readChar();
                tt2.tickerKey = objectInput.readInt();
                tt2.tickerTime = objectInput.readShort();
                if (isSecRdStream) {
                    tt2.tickerTime2 = objectInput.readInt();
                }
                tt2.tradePrice = objectInput.readFloat();
                tt2.tradeQty = objectInput.readInt();
                tt2.orderType = objectInput.readChar();
                arrayList.add(tt2);
            }
            this.tts = arrayList.toArray(new Tt2[0]);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error reading " + this.getClass().getName() + " : " + iOException);
            throw iOException;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.companyCode);
            objectOutput.writeUTF(this.companyShortName);
            objectOutput.writeInt(this.lotSize);
            objectOutput.writeInt(this.tts.length);
            for (int i2 = 0; i2 < this.tts.length; ++i2) {
                objectOutput.writeChar(this.tts[i2].publicTradeType);
                objectOutput.writeChar(this.tts[i2].rejectFlag);
                objectOutput.writeInt(this.tts[i2].tickerKey);
                objectOutput.writeShort(this.tts[i2].tickerTime);
                if (this.isSecWrStream) {
                    objectOutput.writeInt(this.tts[i2].tickerTime2);
                }
                objectOutput.writeFloat(this.tts[i2].tradePrice);
                objectOutput.writeInt(this.tts[i2].tradeQty);
                objectOutput.writeChar(this.tts[i2].orderType);
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error writing " + this.getClass().getName() + " : " + iOException);
            throw iOException;
        }
    }
}

