/*
 * Decompiled with CFR 0.152.
 */
package ats.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;

public class MarginStatus
implements Externalizable,
Serializable,
Cloneable {
    static final long serialVersionUID = 20080931L;
    public String cltcode = null;
    public String repcode = null;
    public double balance = 0.0;
    public double unclearchq = 0.0;
    public double profit = 0.0;
    public double netloss = 0.0;
    public double marginAmt = 0.0;
    public double marginPcent = 0.0;
    public double pmarginAmt = 0.0;
    public double pmarginPcent = 0.0;
    public boolean margincall = false;
    public long timestamp = 0L;

    public String toString() {
        String string = "client " + this.cltcode + "\n";
        string = string + "rep-code " + this.repcode + "\n";
        string = string + "balance " + this.balance + "\n";
        string = string + "unclear-chq " + this.unclearchq + "\n";
        string = string + "P&L " + this.profit + "\n";
        string = string + "margin " + this.marginAmt + ", " + this.marginPcent + "\n";
        string = string + "potential margin " + this.pmarginAmt + ", " + this.pmarginPcent + "\n";
        if (this.margincall) {
            string = string + "MARGIN CALL\n";
        }
        string = string + "timestamp " + new Date(this.timestamp).toString() + "\n";
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cltcode = objectInput.readUTF();
        if (this.cltcode.equals("")) {
            this.cltcode = null;
        }
        this.repcode = objectInput.readUTF();
        if (this.repcode.equals("")) {
            this.repcode = null;
        }
        this.balance = objectInput.readDouble();
        this.unclearchq = objectInput.readDouble();
        this.profit = objectInput.readDouble();
        this.netloss = objectInput.readDouble();
        this.marginAmt = objectInput.readDouble();
        this.marginPcent = objectInput.readDouble();
        this.pmarginAmt = objectInput.readDouble();
        this.pmarginPcent = objectInput.readDouble();
        this.margincall = objectInput.readBoolean();
        this.timestamp = objectInput.readLong();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.cltcode == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.cltcode);
        }
        if (this.repcode == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.repcode);
        }
        objectOutput.writeDouble(this.balance);
        objectOutput.writeDouble(this.unclearchq);
        objectOutput.writeDouble(this.profit);
        objectOutput.writeDouble(this.netloss);
        objectOutput.writeDouble(this.marginAmt);
        objectOutput.writeDouble(this.marginPcent);
        objectOutput.writeDouble(this.pmarginAmt);
        objectOutput.writeDouble(this.pmarginPcent);
        objectOutput.writeBoolean(this.margincall);
        objectOutput.writeLong(this.timestamp);
    }
}

