/*
 * Decompiled with CFR 0.152.
 */
package ats.client;

import ats.client.SeriesConvert;
import blackscholes.Parameter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class Charges
implements Externalizable,
Serializable,
Cloneable {
    static final long serialVersionUID = 20080931L;
    public String cltcode = null;
    public String commodity = null;
    public double web_fut_comm_amt = 0.0;
    public double fc_fut_comm_amt = 0.0;
    public double web_fut_intra_amt = 0.0;
    public double fc_fut_intra_amt = 0.0;
    public double web_oof_comm_rate = 0.0;
    public double fc_oof_comm_rate = 0.0;
    public double web_oof_max_comm = 0.0;
    public double web_oof_min_comm = 0.0;
    public double fc_oof_max_comm = 0.0;
    public double fc_oof_min_comm = 0.0;
    public double fut_tx_fee = 0.0;
    public double fut_levy = 0.0;
    public double fut_comp_levy = 0.0;
    public double oof_tx_fee = 0.0;
    public double oof_levy = 0.0;
    public double oof_comp_levy = 0.0;

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cltcode = objectInput.readUTF();
        if (this.cltcode.equals("")) {
            this.cltcode = null;
        }
        this.commodity = objectInput.readUTF();
        if (this.commodity.equals("")) {
            this.commodity = null;
        }
        this.web_fut_comm_amt = objectInput.readDouble();
        this.fc_fut_comm_amt = objectInput.readDouble();
        this.web_fut_intra_amt = objectInput.readDouble();
        this.fc_fut_intra_amt = objectInput.readDouble();
        this.web_oof_comm_rate = objectInput.readDouble();
        this.fc_oof_comm_rate = objectInput.readDouble();
        this.web_oof_max_comm = objectInput.readDouble();
        this.web_oof_min_comm = objectInput.readDouble();
        this.fc_oof_max_comm = objectInput.readDouble();
        this.fc_oof_min_comm = objectInput.readDouble();
        this.fut_tx_fee = objectInput.readDouble();
        this.fut_levy = objectInput.readDouble();
        this.fut_comp_levy = objectInput.readDouble();
        this.oof_tx_fee = objectInput.readDouble();
        this.oof_levy = objectInput.readDouble();
        this.oof_comp_levy = objectInput.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.cltcode == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.cltcode);
        }
        if (this.commodity == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.commodity);
        }
        objectOutput.writeDouble(this.web_fut_comm_amt);
        objectOutput.writeDouble(this.fc_fut_comm_amt);
        objectOutput.writeDouble(this.web_fut_intra_amt);
        objectOutput.writeDouble(this.fc_fut_intra_amt);
        objectOutput.writeDouble(this.web_oof_comm_rate);
        objectOutput.writeDouble(this.fc_oof_comm_rate);
        objectOutput.writeDouble(this.web_oof_max_comm);
        objectOutput.writeDouble(this.web_oof_min_comm);
        objectOutput.writeDouble(this.fc_oof_max_comm);
        objectOutput.writeDouble(this.fc_oof_min_comm);
        objectOutput.writeDouble(this.fut_tx_fee);
        objectOutput.writeDouble(this.fut_levy);
        objectOutput.writeDouble(this.fut_comp_levy);
        objectOutput.writeDouble(this.oof_tx_fee);
        objectOutput.writeDouble(this.oof_levy);
        objectOutput.writeDouble(this.oof_comp_levy);
    }

    public double charge(String object, int n2, int n3, boolean bl) {
        try {
            double d2;
            object = SeriesConvert.id_to_gem((String)object);
            if (object[2].equals("-")) {
                d2 = bl ? (double)n2 * this.web_fut_comm_amt : (double)n2 * this.fc_fut_comm_amt;
                d2 += (double)n2 * (this.fut_tx_fee + this.fut_levy + this.fut_comp_levy);
            } else {
                double d3 = 0.0;
                if ((object = Parameter.b(SeriesConvert.gem_to_commodity(object[0]))) != null) {
                    d3 = object.b;
                }
                d2 = bl ? (double)n2 * Math.min(Math.max(d3 * this.web_oof_comm_rate * (double)n3, this.web_oof_min_comm), this.web_oof_max_comm) : (double)n2 * Math.min(Math.max(d3 * this.fc_oof_comm_rate * (double)n3, this.fc_oof_min_comm), this.fc_oof_max_comm);
                d2 += (double)n2 * (this.oof_tx_fee + this.oof_levy + this.oof_comp_levy);
            }
            return d2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return 0.0;
        }
    }
}

