/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.future.pricedepth.PriceDepthChartPanel;

public class ChartSettingDialog
extends JDialog {
    private static final Map<String, String> engName = new HashMap<String, String>();
    private static final Map<String, String> chiName = new HashMap<String, String>();
    private final Map<String, Color> colorSetting = new HashMap<String, Color>();
    private final ActionListener colorButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof JButton) {
                JButton button = (JButton)evt.getSource();
                Color color = button.getBackground();
                if ((color = JColorChooser.showDialog(ChartSettingDialog.this, "Color", color)) != null) {
                    button.setBackground(color);
                    ChartSettingDialog.this.colorSetting.put(button.getName(), color);
                }
            }
        }
    };
    private boolean isSubmit = false;
    private int langId = 0;
    private JButton CancelButton;
    private JButton DefaultButton;
    private JButton SubmitButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;

    private ChartSettingDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void set(Map<String, Color> colorSetting) {
        if (colorSetting != null) {
            this.colorSetting.putAll(colorSetting);
            this.jPanel1.removeAll();
            for (String k2 : colorSetting.keySet()) {
                Color c2 = colorSetting.get(k2);
                JLabel cl = new JLabel();
                cl.setName(k2);
                cl.setText(this.convertName(k2));
                JButton cb = new JButton();
                cb.setName(k2);
                cb.setBackground(c2);
                cb.addActionListener(this.colorButtonActionListener);
                this.jPanel1.add(cl);
                this.jPanel1.add(cb);
            }
        }
        this.pack();
    }

    public static Map<String, Color> showDialog(Component component, String title, Object initialColor, int langId) throws HeadlessException {
        Color oc;
        TreeMap<String, Color> result = new TreeMap<String, Color>();
        if (initialColor instanceof Map) {
            Map m2 = (Map)initialColor;
            for (Object k2 : m2.keySet()) {
                Object val = m2.get(k2);
                if (!(val instanceof Color)) continue;
                result.put(k2.toString(), (Color)val);
            }
            if (result.size() > 0) {
                Frame frame = ChartSettingDialog.findFrame(component);
                if (frame != null) {
                    ChartSettingDialog dialog = new ChartSettingDialog(frame, true);
                    dialog.setTitle(title);
                    dialog.set(result);
                    dialog.setLocationRelativeTo(null);
                    dialog.setLanguage(langId);
                    dialog.setVisible(true);
                    if (dialog.isSubmit) {
                        result.putAll(dialog.colorSetting);
                    }
                } else {
                    System.out.println("ChartSettingDialog can't find Frame");
                }
            } else {
                System.out.println("ChartSettingDialog can't find any Color Setting");
            }
        }
        if ((oc = (Color)result.get("SETTING_BA_BIDBARCOLOR")) != null) {
            oc = new Color(oc.getRed(), oc.getGreen(), oc.getBlue(), 200);
        }
        result.put("SETTING_BA_BIDBARCOLOR", oc);
        oc = (Color)result.get("SETTING_BA_ASKBARCOLOR");
        if (oc != null) {
            oc = new Color(oc.getRed(), oc.getGreen(), oc.getBlue(), 200);
        }
        result.put("SETTING_BA_ASKBARCOLOR", oc);
        return result;
    }

    private static Frame findFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return ChartSettingDialog.findFrame(component.getParent());
    }

    public void setLanguage(int langId) {
        if (langId == 1) {
            this.langId = 1;
            this.DefaultButton.setText("Default");
            this.SubmitButton.setText("Submit");
            this.CancelButton.setText("Cancel");
        } else {
            this.langId = 0;
            this.DefaultButton.setText("\u9810\u8a2d");
            this.SubmitButton.setText("\u78ba\u5b9a");
            this.CancelButton.setText("\u53d6\u6d88");
        }
    }

    private String convertName(String key) {
        String result = this.langId == 1 ? engName.get(key) : chiName.get(key);
        if (result == null) {
            return key;
        }
        return result;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.SubmitButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel4 = new JPanel();
        this.DefaultButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new GridLayout(0, 2));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel2.setOpaque(false);
        this.SubmitButton.setText("Submit");
        this.SubmitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartSettingDialog.this.SubmitButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.SubmitButton);
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartSettingDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.CancelButton);
        this.jPanel3.add((Component)this.jPanel2, "Center");
        this.jPanel4.setOpaque(false);
        this.DefaultButton.setText("Default");
        this.DefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartSettingDialog.this.DefaultButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.DefaultButton);
        this.jPanel3.add((Component)this.jPanel4, "West");
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void SubmitButtonActionPerformed(ActionEvent evt) {
        this.isSubmit = true;
        this.setVisible(false);
        this.dispose();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void DefaultButtonActionPerformed(ActionEvent evt) {
        this.set(PriceDepthChartPanel.getDefaultColorSetting());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartSettingDialog dialog = new ChartSettingDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e2) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    static {
        engName.put("SETTING_BGCOLOR", "BG Color 1");
        engName.put("SETTING_BGCOLOR2", "BG Color 2");
        engName.put("SETTING_BGCOLOR3", "BG Color 3");
        engName.put("SETTING_GRIDCOLOR", "Grid Color");
        engName.put("SETTING_LABELCOLOR", "Label Color");
        engName.put("SETTING_BA_BIDBARCOLOR", "Bid Color");
        engName.put("SETTING_BA_ASKBARCOLOR", "Ask Color");
        engName.put("SETTING_HIGHLIGHTCOLOR", "HighLight Color");
        chiName.put("SETTING_BGCOLOR", "\u80cc\u666f 1");
        chiName.put("SETTING_BGCOLOR2", "\u80cc\u666f 2");
        chiName.put("SETTING_BGCOLOR3", "\u80cc\u666f 3");
        chiName.put("SETTING_GRIDCOLOR", "\u683c\u7dda");
        chiName.put("SETTING_LABELCOLOR", "\u6a19\u7c64");
        chiName.put("SETTING_BA_BIDBARCOLOR", "\u8cb7");
        chiName.put("SETTING_BA_ASKBARCOLOR", "\u6cbd");
        chiName.put("SETTING_HIGHLIGHTCOLOR", "\u6a19\u793a\u984f\u8272");
    }
}

