/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDataInterval;

public class ChartControlUtil {
    private ChartControlUtil() {
    }

    public static void autoScale(IlvChart chart, boolean auto) {
        chart.getXAxis().setAutoDataRange(auto);
        chart.getXAxis().setAutoVisibleRange(auto);
    }

    public static void scroll2Center(IlvChart chart, double mid) {
        IlvDataInterval di = chart.getXAxis().getVisibleRange();
        double vMid = di.getMiddle();
        double delta = mid - vMid;
        chart.scroll(delta, 0.0, 0);
    }

    public static void zoomTo(IlvChart chart, int per, int zoomSteps) {
        ChartControlUtil.autoScale(chart, false);
        IlvDataInterval di = chart.getXAxis().getDataRange();
        double delta = di.getLength() * ((100.0 - (double)per) / 100.0) / 2.0;
        if (di.getLength() > 200.0 && per <= 20) {
            delta = (di.getLength() - (double)per * 3.0) / 2.0;
        }
        di.max -= delta;
        di.min += delta;
        chart.getXAxis().setVisibleRange(di);
    }

    public static void zoomTo(IlvChart chart, int per, int minPer, int maxPer) {
        ChartControlUtil.autoScale(chart, false);
        IlvDataInterval di = chart.getXAxis().getDataRange();
        double minDelta = (di.getLength() - (double)minPer * 3.0) / 2.0;
        double maxDelta = di.getLength() * ((100.0 - (double)maxPer) / 100.0) / 2.0;
        double diffDelta = (Math.max(maxDelta, minDelta) - Math.min(maxDelta, minDelta)) / ((double)maxPer - (double)minPer);
        double delta = Math.max(maxDelta, minDelta) - diffDelta * Math.max(0.1, (double)per - (double)minPer);
        di.max -= delta;
        di.min += delta;
        chart.getXAxis().setVisibleRange(di);
    }
}

