/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.renderer.IlvSinglePolylineRenderer;
import java.awt.Color;
import java.awt.Paint;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;
import leaseLineQuote.candle.graph.indicator.WilliamsRDataSet;

public class WilliamsRIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    WilliamsRDataSet wDataSet;
    IlvDataIndicator indicator;
    Color color;

    public WilliamsRIndicator(StockDataSource stockDS, Color color, int period) {
        super(stockDS);
        this.color = color;
        this.wDataSet = new WilliamsRDataSet(null, period);
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        IlvStyle style = IlvStyle.createStroked(this.color);
        this.renderer = new IlvSinglePolylineRenderer(style);
        this.indicator = new IlvDataIndicator(0, -50.0, null);
        this.indicator.setStyle(new IlvStyle(1.1f, (Paint)Color.RED.darker()));
        chart.addDecoration(this.indicator);
        this.refresh();
        chart.addRenderer(this.renderer);
    }

    @Override
    public void setColor(Color[] colors) {
        this.color = colors[0];
        this.renderer.setStyles(new IlvStyle[]{IlvStyle.createStroked(this.color)});
    }

    @Override
    public void setCfg(Object cfg) {
        int[] vals = (int[])cfg;
        this.wDataSet.setPeriod(vals[0]);
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
            this.chart.removeDecoration(this.indicator);
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void refresh() {
        IlvDataSet hids = this.stockDS.getHighDataSet();
        IlvDataSet lods = this.stockDS.getLowDataSet();
        IlvDataSet closeds = this.stockDS.getCloseDataSet();
        IlvDataSet[] dataSets = null;
        if (hids != null && lods != null && closeds != null) {
            dataSets = new IlvDataSet[]{hids, lods, closeds};
        }
        this.wDataSet.setDataSets(dataSets);
        if (dataSets == null) {
            this.renderer.getDataSource().setDataSets(null);
        } else if (!this.renderer.getDataSource().containsDataSet(this.wDataSet)) {
            this.renderer.getDataSource().addDataSet(this.wDataSet);
        }
    }

    @Override
    public String getName() {
        return "Williams %R";
    }

    @Override
    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        if (this.renderer != null && this.wDataSet.getDataCount() > 0) {
            return this.renderer.getDisplayPoint(this.wDataSet, dataIdx);
        }
        return null;
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.wDataSet;
    }
}

