/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.candle.graph.indicator.IndicatorUtil;
import leaseLineQuote.candle.graph.indicator.PeriodDataSet;

class RSIDataSet
extends PeriodDataSet {
    public RSIDataSet(int period) {
        this((IlvDataSet)null, period);
    }

    public RSIDataSet(IlvDataSet dataSet, int period) {
        IlvDataSet[] ilvDataSetArray;
        if (dataSet == null) {
            ilvDataSetArray = null;
        } else {
            IlvDataSet[] ilvDataSetArray2 = new IlvDataSet[1];
            ilvDataSetArray = ilvDataSetArray2;
            ilvDataSetArray2[0] = dataSet;
        }
        super(ilvDataSetArray, period);
        this.setMaxDataSetCount(1);
    }

    @Override
    protected String getIndicatorName() {
        return "RSI(" + this.getPeriod() + ")";
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.getPeriod() == 0 || this.getDataSetCount() == 0) {
            return null;
        }
        IndicatorData data = IndicatorData.get(this.getDataSet(0));
        if (data == null) {
            return null;
        }
        return IndicatorUtil.computeRSI(data, this.getPeriod());
    }
}

