/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import leaseLineQuote.candle.graph.indicator.IndicatorData;

public class IndicatorUtil {
    public static final int SMA = 1;
    public static final int EMA = 2;
    public static final Double UNDEF_VALUE = new Double(Double.MIN_VALUE);

    public static double[] computeSMA(IndicatorData data, int period) {
        int j2;
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        if (start >= count) {
            return null;
        }
        double[] vals = data.data;
        double[] res = new double[count];
        double sum = 0.0;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int c2 = j2 + period;
        for (j2 = start < -1 ? -start : 0; j2 < c2; ++j2) {
            sum += vals[j2];
        }
        res[i2++] = sum / (double)period;
        while (i2 < count) {
            sum = sum - vals[j2 - period] + vals[j2];
            res[i2] = sum / (double)period;
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeEMA(IndicatorData data, int period) {
        int j2;
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        if (start >= count) {
            return null;
        }
        double[] vals = data.data;
        double[] res = new double[count];
        double k2 = 2.0 / (double)(1 + period);
        double sum = 0.0;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int c2 = j2 + period;
        for (j2 = start < -1 ? -start : 0; j2 < c2; ++j2) {
            sum += vals[j2];
        }
        res[i2++] = sum / (double)period;
        while (i2 < count) {
            res[i2] = k2 * (vals[j2] - res[i2 - 1]) + res[i2 - 1];
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeRSI(IndicatorData data, int period) {
        double close;
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        if (start >= count) {
            return null;
        }
        double[] vals = data.data;
        double[] res = new double[count];
        double avgUp = 0.0;
        double avgDown = 0.0;
        int pp = period - 1;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int j2 = start < 0 ? -start : 0;
        double prevClose = vals[j2++];
        int c2 = j2 + period - 1;
        while (j2 < c2) {
            close = vals[j2];
            if (prevClose <= close) {
                avgUp += close - prevClose;
            } else {
                avgDown += prevClose - close;
            }
            prevClose = close;
            ++j2;
        }
        res[i2++] = (avgUp /= (double)period) / (avgUp + (avgDown /= (double)period)) * 100.0;
        while (i2 < count) {
            close = vals[j2];
            if (prevClose <= close) {
                avgUp = (avgUp * (double)pp + close - prevClose) / (double)period;
                avgDown = avgDown * (double)pp / (double)period;
            } else {
                avgUp = avgUp * (double)pp / (double)period;
                avgDown = (avgDown * (double)pp + prevClose - close) / (double)period;
            }
            res[i2] = avgUp / (avgUp + avgDown) * 100.0;
            prevClose = close;
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeLow(IndicatorData data, int period, boolean backward) {
        int j2;
        int i2;
        int start = period - data.headerLength;
        if (!backward) {
            --start;
        }
        int count = data.dataCount;
        double[] res = new double[count];
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int n2 = j2 = start < (backward ? 0 : -1) ? -start : 0;
        while (i2 < count) {
            res[i2] = IndicatorUtil.computeMin(data.data, j2, period);
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeHigh(IndicatorData data, int period, boolean backward) {
        int j2;
        int i2;
        int start = period - data.headerLength;
        if (!backward) {
            --start;
        }
        int count = data.dataCount;
        double[] res = new double[count];
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int n2 = j2 = start < (backward ? 0 : -1) ? -start : 0;
        while (i2 < count) {
            res[i2] = IndicatorUtil.computeMax(data.data, j2, period);
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeOscillator(IndicatorData data, int fastPeriod, int slowPeriod, int avgType) {
        double[] slow = null;
        double[] fast = null;
        if (avgType == 1) {
            slow = IndicatorUtil.computeSMA(data, slowPeriod);
            fast = IndicatorUtil.computeSMA(data, fastPeriod);
        } else {
            slow = IndicatorUtil.computeEMA(data, slowPeriod);
            fast = IndicatorUtil.computeEMA(data, fastPeriod);
        }
        if (slow == null || fast == null) {
            return null;
        }
        int count = data.dataCount;
        double uv = UNDEF_VALUE;
        for (int i2 = 0; i2 < count; ++i2) {
            if (slow[i2] == uv) {
                fast[i2] = uv;
                continue;
            }
            int n2 = i2;
            fast[n2] = fast[n2] - slow[i2];
        }
        return fast;
    }

    public static double[] computeStdDev(IndicatorData data, int period) {
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        double[] res = new double[count];
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int j2 = start < -1 ? -start : 0;
        double[] vals = data.data;
        while (i2 < count) {
            int k2;
            double avg = IndicatorUtil.computeAverage(vals, j2, period);
            double sum = 0.0;
            int c2 = k2 + period;
            for (k2 = j2; k2 < c2; ++k2) {
                double dev = avg - vals[k2];
                sum += dev * dev;
            }
            res[i2] = Math.sqrt(sum / (double)period);
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double computeStdDev(double[] values) {
        double count = values.length;
        double sum = 0.0;
        for (double d2 : values) {
            sum += d2;
        }
        double avg = sum / count;
        double sd = 0.0;
        for (double d3 : values) {
            double t2 = d3 - avg;
            sd += t2 * t2;
        }
        sd /= count;
        sd = Math.sqrt(sd);
        return sd;
    }

    public static double[] computeStochastic(IndicatorData hiData, IndicatorData loData, IndicatorData closeData, int period) {
        int j2;
        int i2;
        if (hiData == null || loData == null || closeData == null) {
            return null;
        }
        int count = closeData.dataCount;
        int start = period - closeData.headerLength - 1;
        if (count < start) {
            return null;
        }
        double[] hi = hiData.data;
        double[] lo = loData.data;
        double[] close = closeData.data;
        double[] res = new double[count];
        double hh = -1.7976931348623157E308;
        double ll = Double.MAX_VALUE;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int n2 = j2 = start < -1 ? -start : 0;
        while (i2 < count) {
            hh = IndicatorUtil.computeMax(hi, j2, period);
            ll = IndicatorUtil.computeMin(lo, j2, period);
            res[i2] = 100.0 * (close[j2 + period - 1] - ll) / (hh - ll);
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeWilliamsR(IndicatorData hiData, IndicatorData loData, IndicatorData closeData, int period) {
        int j2;
        int i2;
        if (hiData == null || loData == null || closeData == null) {
            return null;
        }
        int count = closeData.dataCount;
        int start = period - closeData.headerLength - 1;
        if (count < start) {
            return null;
        }
        double[] hi = hiData.data;
        double[] lo = loData.data;
        double[] close = closeData.data;
        double[] res = new double[count];
        double hh = -1.7976931348623157E308;
        double ll = Double.MAX_VALUE;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int n2 = j2 = start < -1 ? -start : 0;
        while (i2 < count) {
            hh = IndicatorUtil.computeMax(hi, j2, period);
            ll = IndicatorUtil.computeMin(lo, j2, period);
            res[i2] = -100.0 * (hh - close[j2 + period - 1]) / (hh - ll);
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[][] computePVO(double[] volume, int count, int fastPeriod, int slowPeriod, int signalPeriod, boolean divergence) {
        int i2;
        if (fastPeriod > slowPeriod) {
            throw new IllegalArgumentException();
        }
        int resCount = 1;
        if (signalPeriod > 1) {
            ++resCount;
            if (divergence) {
                ++resCount;
            }
        }
        double[][] res = new double[resCount][];
        Object slow = null;
        Object fast = null;
        res[0] = new double[count];
        for (i2 = 0; i2 < slowPeriod; ++i2) {
            res[0][i2] = UNDEF_VALUE;
        }
        while (i2 < count) {
            res[0][i2] = 100.0 * ((fast[i2] - slow[i2]) / fast[i2]);
            ++i2;
        }
        if (resCount == 1) {
            return res;
        }
        if (divergence) {
            // empty if block
        }
        return res;
    }

    private static double computeMin(double[] vals, int start, int period) {
        double min = Double.MAX_VALUE;
        int c2 = start + period;
        for (int i2 = start; i2 < c2; ++i2) {
            if (!(vals[i2] < min)) continue;
            min = vals[i2];
        }
        return min;
    }

    private static double computeMax(double[] vals, int start, int period) {
        double max = -1.7976931348623157E308;
        int c2 = start + period;
        for (int i2 = start; i2 < c2; ++i2) {
            if (!(vals[i2] > max)) continue;
            max = vals[i2];
        }
        return max;
    }

    private static double computeAverage(double[] vals, int start, int period) {
        double avg = 0.0;
        int c2 = start + period;
        for (int i2 = start; i2 < c2; ++i2) {
            avg += vals[i2];
        }
        return avg / (double)period;
    }

    private IndicatorUtil() {
    }

    public static void main(String[] args) {
        double[] da = new double[]{17369.08984375, 17422.119140625, 17660.01953125, 18013.16015625, 18258.5703125, 18247.109375, 19000.560546875, 19129.099609375, 19924.580078125, 20632.30078125, 21133.6796875, 22443.73046875, 22113.509765625, 22736.869140625, 23099.779296875, 20926.7890625, 20637.240234375, 21251.98046875, 21092.869140625, 20318.7890625};
        System.out.println(da.length);
        double sd = IndicatorUtil.computeStdDev(da);
        System.out.println(sd);
    }
}

