/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.core;

import ilog.views.chart.IlvDisplayPoint;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class LowerDataStatusControl
implements ChartColors {
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    private static LowerDataStatusControl hsc;
    private Hashtable headerHash = new Hashtable();

    private LowerDataStatusControl() {
    }

    public static LowerDataStatusControl getInstance() {
        if (hsc == null) {
            hsc = new LowerDataStatusControl();
        }
        return hsc;
    }

    private void clearLabel(JPanel header) {
        JLabel[] dataLbls = (JLabel[])header.getClientProperty("STATUS");
        if (dataLbls != null && dataLbls.length > 0) {
            for (int i2 = 0; i2 < dataLbls.length; ++i2) {
                header.remove(dataLbls[i2]);
            }
        }
        header.putClientProperty("STATUS", new JLabel[0]);
        JLabel[] nameLbls = (JLabel[])header.getClientProperty("NAME");
        if (nameLbls != null && nameLbls.length > 0) {
            for (int i3 = 0; i3 < nameLbls.length; ++i3) {
                header.remove(nameLbls[i3]);
            }
        }
        header.putClientProperty("NAME", new JLabel[0]);
    }

    public void registerHeader(int lowerChartIdx, JPanel header) {
        this.headerHash.remove(header);
        this.headerHash.put(new Integer(lowerChartIdx), header);
    }

    public void setDatasToLabels(boolean isIndiceCode, int lowerChartIdx, LinkedHashMap dataMap) {
        int i2;
        JPanel header = (JPanel)this.headerHash.get(new Integer(lowerChartIdx));
        if (header == null) {
            System.out.println("[ERR]" + lowerChartIdx + " repected header not found.");
            return;
        }
        JLabel[] dataLbls = (JLabel[])header.getClientProperty("STATUS");
        JLabel[] nameLbls = (JLabel[])header.getClientProperty("NAME");
        if (dataLbls != null && dataLbls.length != dataMap.size()) {
            this.clearLabel(header);
            dataLbls = (JLabel[])header.getClientProperty("STATUS");
            nameLbls = (JLabel[])header.getClientProperty("NAME");
        } else if (dataLbls == null) {
            header.putClientProperty("STATUS", new JLabel[0]);
            header.putClientProperty("NAME", new JLabel[0]);
            dataLbls = (JLabel[])header.getClientProperty("STATUS");
            nameLbls = (JLabel[])header.getClientProperty("NAME");
        }
        String[] names = dataMap.keySet().toArray(new String[0]);
        IlvDisplayPoint[] datas = dataMap.values().toArray(new IlvDisplayPoint[0]);
        if (dataLbls.length == 0) {
            dataLbls = new JLabel[names.length];
            nameLbls = new JLabel[names.length];
            for (i2 = 0; i2 < names.length; ++i2) {
                nameLbls[i2] = this.createNameLabel(names[i2]);
                dataLbls[i2] = this.createLabel();
                header.add(nameLbls[i2]);
                header.add(dataLbls[i2]);
            }
            header.putClientProperty("STATUS", dataLbls);
            header.putClientProperty("NAME", nameLbls);
        } else {
            for (i2 = 0; i2 < names.length; ++i2) {
                if (names[i2].equalsIgnoreCase("volume")) {
                    if (isIndiceCode) {
                        nameLbls[i2].setText("Turnover");
                        continue;
                    }
                    nameLbls[i2].setText(names[i2]);
                    continue;
                }
                nameLbls[i2].setText(names[i2]);
            }
        }
        for (i2 = 0; i2 < names.length; ++i2) {
            double value = datas[i2].getYData();
            String val = "0";
            val = value < 10000.0 ? CandlePanel.numFmt.format(value) : (value < 1.0E7 ? CandlePanel.numFmt.format(value / 1000.0) + "K" : (value < 1.0E10 ? CandlePanel.numFmt.format(value / 1000000.0) + "M" : CandlePanel.numFmt.format(value / 1.0E9) + "B"));
            dataLbls[i2].setText(val);
        }
        header.updateUI();
    }

    private JLabel createLabel() {
        JLabel status = new JLabel(" ", 4);
        status.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        status.setFont(DEFAULT_FONT);
        Dimension size = status.getPreferredSize();
        size.width = 85;
        status.setPreferredSize(size);
        status.setMinimumSize(size);
        status.setMaximumSize(size);
        status.setForeground(FIXEDLABEL_FOREGROUND);
        status.setBackground(FIXEDLABEL_BACKGROUND);
        status.setOpaque(true);
        return status;
    }

    private JLabel createNameLabel(String name) {
        JLabel nameLbl = new JLabel(name, 4);
        nameLbl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 4));
        nameLbl.setFont(DEFAULT_FONT);
        Dimension size = nameLbl.getPreferredSize();
        size.width = 100;
        nameLbl.setPreferredSize(size);
        nameLbl.setMinimumSize(size);
        nameLbl.setMaximumSize(size);
        nameLbl.setForeground(FIXEDLABEL_FOREGROUND);
        nameLbl.setOpaque(false);
        return nameLbl;
    }
}

