/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.datasource.histrecord;

import hk.com.realink.histnews.typeimple.HistRecordRes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CandleCache {
    private static final long CACHE_TIME = 1800000L;
    private int MAX_LIMIT = 8;
    private final LinkedList<String> keyList = new LinkedList();
    private final HashMap<String, HistRecordRes> valueMap = new HashMap();
    private final HashMap<String, Long> valueTimeMap = new HashMap();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock rl = this.rwl.readLock();
    private final Lock wl = this.rwl.writeLock();

    public void putCandle(String key, HistRecordRes value) {
        this.putCandle(key, value, 1800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCandle(String key, HistRecordRes value, long timeout) {
        try {
            this.wl.lock();
            if (this.keyList.contains(key)) {
                this.keyList.remove(key);
            }
            this.keyList.add(key);
            this.valueMap.put(key, value);
            this.valueTimeMap.put(key, System.currentTimeMillis() + timeout);
            if (this.keyList.size() > this.MAX_LIMIT) {
                String rk = this.keyList.removeFirst();
                this.valueMap.remove(rk);
                this.valueTimeMap.remove(rk);
            }
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistRecordRes getCandle(String key) {
        try {
            this.rl.lock();
            if (this.valueTimeMap.get(key) >= System.currentTimeMillis()) {
                HistRecordRes histRecordRes = this.valueMap.get(key);
                return histRecordRes;
            }
            this.keyList.remove(key);
            this.valueMap.remove(key);
            this.valueTimeMap.remove(key);
            HistRecordRes histRecordRes = null;
            return histRecordRes;
        }
        catch (Exception e2) {
            HistRecordRes histRecordRes = null;
            return histRecordRes;
        }
        finally {
            this.rl.unlock();
        }
    }

    public void clear() {
        try {
            this.wl.lock();
            this.keyList.clear();
            this.valueMap.clear();
        }
        finally {
            this.wl.unlock();
        }
    }

    public CandleCache() {
    }

    public CandleCache(int cacheSize) {
        this.MAX_LIMIT = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String paramString() {
        try {
            this.rl.lock();
            StringBuilder strBuff = new StringBuilder(100).append("[CAN][CACHE]");
            for (String k2 : this.keyList) {
                strBuff.append('[').append(this.valueMap.get((Object)k2).getHistRecord().companyCode).append(']');
            }
            String string = strBuff.toString();
            return string;
        }
        finally {
            this.rl.unlock();
        }
    }
}

