/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle;

import hk.com.realink.histnews.typeimple.HistRecordRes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import leaseLineQuote.StyledFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.control.ControlPanel;
import leaseLineQuote.candle.control.UpdateCandle;
import leaseLineQuote.candle.graph.ControlInterface;
import leaseLineQuote.candle.graph.RENDERER;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class CandleNewFrame {
    private CandleConfigFrame configFrame;
    private ControlPanel controlPanel;
    public static ControlInterface ctrInf;
    private static volatile CandleNewFrame candleNewFrame;
    private int iterdayPeriod = -1;
    private JPanel bgPanel;
    private StyledFrame styledFrame;
    private JFrame jFrame;
    private JPanel candleInsidePanel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CandleNewFrame getInstance() {
        if (candleNewFrame != null) return candleNewFrame;
        Class<CandleNewFrame> clazz = CandleNewFrame.class;
        synchronized (CandleNewFrame.class) {
            if (candleNewFrame != null) return candleNewFrame;
            candleNewFrame = new CandleNewFrame();
            // ** MonitorExit[var0] (shouldn't be in output)
            return candleNewFrame;
        }
    }

    public void request(String sctyCode) {
        CandleNewFrame candleNewFrame = this;
        candleNewFrame.controlPanel.getInstance().requestHistory(sctyCode);
    }

    private CandleNewFrame() {
        try {
            RENDERER.startupILog();
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    public StyledFrame getStyledFrame() {
        if (this.styledFrame == null) {
            this.styledFrame = new StyledFrame();
            this.styledFrame.getContentPane().add(this.bgPanel);
            this.setFrame();
        }
        return this.styledFrame;
    }

    public JFrame getJFrame() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.jFrame == null) {
                this.jFrame = new JFrame();
                this.jFrame.getContentPane().setLayout(new BorderLayout());
                this.jFrame.getContentPane().add((Component)this.bgPanel, "Center");
                this.setFrame();
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CandleNewFrame.this.getJFrame();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.jFrame;
    }

    public boolean isFrameVisible() {
        if (this.jFrame != null) {
            return this.jFrame.isVisible();
        }
        if (this.styledFrame != null) {
            return this.styledFrame.isVisible();
        }
        return false;
    }

    public void updateCandle(HistRecordRes historyResponse) {
    }

    public void showConfig() {
        this.configFrame.setSize(280, 400);
        this.configFrame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 140.0) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 125.0) / 2);
        this.configFrame.setVisible(true);
    }

    public boolean isIterdayPeriod() {
        return this.iterdayPeriod >= 0;
    }

    public void setIterdayPeriod(int iterdayPeriod) {
        this.iterdayPeriod = iterdayPeriod;
    }

    private void jbInit() throws Exception {
        this.controlPanel = ControlPanel.getInstance();
        this.controlPanel.btnFitPage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                ctrInf.setFitAction();
            }
        });
        this.controlPanel.btnPrevPage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                ctrInf.setForwardAction();
            }
        });
        this.controlPanel.btnBackPage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                ctrInf.setBackwardAction();
            }
        });
        this.controlPanel.btnConfig.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                CandleNewFrame.this.showConfig();
            }
        });
        this.controlPanel.comboBoxFuturePeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    CandleNewFrame.this.controlPanel.interdayRefresh();
                }
            }
        });
        this.controlPanel.comboBoxMinPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1 && CandleNewFrame.this.controlPanel.getFrequency() == 3) {
                    CandleNewFrame.this.controlPanel.setIsChgCode(false);
                    ctrInf.setStockDataSourcePeriod(3, CandleNewFrame.this.controlPanel.getMinute());
                }
            }
        });
        this.bgPanel = new JPanel();
        this.bgPanel.setLayout(new BorderLayout());
        this.configFrame = new CandleConfigFrame();
        this.candleInsidePanel = new JPanel();
        ctrInf = CandlePanel.getInstance();
        ctrInf.init(this.candleInsidePanel);
        this.configFrame.updateSetting();
    }

    private void setFrame() {
        if (this.jFrame == null) {
            this.bgPanel.add((Component)this.controlPanel.getTopPanel(true), "North");
        } else {
            this.bgPanel.add((Component)this.controlPanel.getTopPanel(true), "North");
        }
        this.bgPanel.add((Component)this.candleInsidePanel, "Center");
    }

    public static ControlInterface getControlInterface() {
        return ctrInf;
    }

    public void setInvalid() {
        System.out.println("[CANDLE_NEW_FRAME]invalid.");
        ctrInf.loadQuote("-3", -1, -1, -1);
    }

    public void updateSetting() {
        this.configFrame.updateSetting();
    }

    public void setChinese() {
        this.configFrame.setChinese();
        this.controlPanel.setChinese();
    }

    public void setEnglish() {
        this.configFrame.setEnglish();
        this.controlPanel.setEnglish();
    }

    public void setStockChartVisible(boolean visible) {
        this.controlPanel.setStockChartVisible(visible);
    }

    public void setFutureMinChartVisible(boolean visible) {
        this.controlPanel.setFutureMinChartVisible(visible);
    }

    public void setStockMinChartVisible(boolean visible) {
        this.controlPanel.setStockMinChartVisible(visible);
    }

    public void setUpdateTime(long check, long sleepTime) {
        UpdateCandle.getInstance().setUpdateTime(check, sleepTime);
    }

    public void setAutoRefresh(boolean isAutoRefresh) {
        UpdateCandle.getInstance().setAutoRefresh(isAutoRefresh);
    }

    public void setCurrentTime(String inTime) {
        UpdateCandle.getInstance().setCurrentTime(inTime);
    }
}

