/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public class IlvImageUtil {
    public static Image getImageFromFile(Class paramClass, String paramString) throws IOException {
        int i2;
        InputStream localInputStream = paramClass.getResourceAsStream(paramString);
        if (localInputStream == null) {
            throw new IOException(paramClass + ".getResourceAsStream(" + paramString + ") returns null");
        }
        byte[][] arrayOfByte = new byte[1][];
        BufferedInputStream localBufferedInputStream = new BufferedInputStream(localInputStream);
        ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(1024);
        arrayOfByte[0] = new byte[63];
        while ((i2 = localBufferedInputStream.read(arrayOfByte[0])) > 0) {
            localByteArrayOutputStream.write(arrayOfByte[0], 0, i2);
        }
        localBufferedInputStream.close();
        localByteArrayOutputStream.flush();
        arrayOfByte[0] = localByteArrayOutputStream.toByteArray();
        if (arrayOfByte[0] == null) {
            throw new IOException(paramClass.getName() + "/" + paramString + " not found.");
        }
        if (arrayOfByte[0].length == 0) {
            throw new IOException("warning: " + paramString + " is zero-length");
        }
        return Toolkit.getDefaultToolkit().createImage(arrayOfByte[0]);
    }

    public static Image loadImageFromFile(Class paramClass, String paramString) throws IOException {
        return IlvImageUtil.a(IlvImageUtil.getImageFromFile(paramClass, paramString));
    }

    public static BufferedImage createBufferedImage(Image paramImage, int paramInt) {
        if (paramImage == null) {
            return null;
        }
        int i2 = paramImage.getWidth(null);
        int j2 = paramImage.getHeight(null);
        if (i2 <= 0 || j2 <= 0) {
            return null;
        }
        BufferedImage localBufferedImage = new BufferedImage(i2, j2, paramInt);
        Graphics localGraphics = localBufferedImage.getGraphics();
        if (localGraphics == null) {
            return null;
        }
        localGraphics.drawImage(paramImage, 0, 0, null);
        localGraphics.dispose();
        return localBufferedImage;
    }

    public static Image loadImage(URL paramURL) {
        return IlvImageUtil.a(Toolkit.getDefaultToolkit().getImage(paramURL));
    }

    public static Image loadImage(String paramString) {
        Image localImage = null;
        try {
            URL localURL = new File(paramString).toURL();
            localImage = IlvImageUtil.loadImage(localURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return localImage;
    }

    public static BufferedImage loadImage(String paramString, int paramInt) {
        BufferedImage localBufferedImage = null;
        try {
            URL localURL = new File(paramString).toURL();
            localBufferedImage = IlvImageUtil.loadImage(localURL, paramInt);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return localBufferedImage;
    }

    public static BufferedImage loadImage(URL paramURL, int paramInt) {
        if (paramURL == null) {
            throw new IllegalArgumentException("URL of image is null");
        }
        BufferedImage localObject1 = null;
        String str = paramURL.toString().toLowerCase();
        if (str.endsWith(".jpg") || str.endsWith(".jpeg")) {
            BufferedImage localObject2 = IlvImageUtil.a(paramURL);
            if (localObject2 != null) {
                localObject1 = localObject2.getType() != paramInt ? IlvImageUtil.createBufferedImage(localObject2, paramInt) : localObject2;
            }
        } else {
            Image localObject2 = IlvImageUtil.loadImage(paramURL);
            localObject1 = localObject2 == null ? null : IlvImageUtil.createBufferedImage(localObject2, paramInt);
        }
        return localObject1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized BufferedImage a(URL paramURL) {
        BufferedImage localBufferedImage = null;
        if (paramURL != null) {
            InputStream localInputStream = null;
            try {
                localInputStream = paramURL.openStream();
                localBufferedImage = ImageIO.read(localInputStream);
                try {
                    if (localInputStream != null) {
                        localInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (localBufferedImage == null) {
                    BufferedImage bufferedImage = localBufferedImage;
                    return bufferedImage;
                }
            }
            catch (IOException localIOException2) {
                localBufferedImage = null;
            }
            finally {
                try {
                    if (localInputStream != null) {
                        localInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (localBufferedImage.getWidth() <= 0 || localBufferedImage.getHeight() <= 0) {
                localBufferedImage = null;
            }
        }
        return localBufferedImage;
    }

    private static Image a(Image paramImage) {
        if (paramImage != null) {
            MediaTracker localMediaTracker = new MediaTracker(new Component(){});
            localMediaTracker.addImage(paramImage, 0);
            try {
                localMediaTracker.waitForAll();
            }
            catch (InterruptedException localInterruptedException) {
                localMediaTracker.removeImage(paramImage);
                paramImage = null;
            }
            finally {
                if (paramImage != null) {
                    localMediaTracker.removeImage(paramImage);
                }
                if (localMediaTracker.isErrorAny()) {
                    paramImage = null;
                }
                if (paramImage != null && (paramImage.getWidth(null) < 0 || paramImage.getHeight(null) < 0)) {
                    paramImage = null;
                }
            }
        }
        return paramImage;
    }
}

