/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import java.awt.geom.Rectangle2D;

public final class Ilv3DBounds {
    public double xMin;
    public double yMin;
    public double zMin;
    public double xMax;
    public double yMax;
    public double zMax;

    public Ilv3DBounds() {
    }

    public Ilv3DBounds(Ilv3DBounds ilv3DBounds) {
        this(ilv3DBounds.xMin, ilv3DBounds.yMin, ilv3DBounds.zMin, ilv3DBounds.xMax, ilv3DBounds.yMax, ilv3DBounds.zMax);
    }

    public Ilv3DBounds(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.a(d2, d3, d4, d5, d6, d7);
    }

    private void a(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.xMin = d2;
        this.yMin = d3;
        this.zMin = d4;
        this.xMax = d5;
        this.yMax = d6;
        this.zMax = d7;
    }

    public Ilv3DVector getCenter() {
        return new Ilv3DVector((this.xMin + this.xMax) / 2.0, (this.yMin + this.yMax) / 2.0, (this.zMin + this.zMax) / 2.0);
    }

    public void add(Ilv3DBounds ilv3DBounds) {
        if (ilv3DBounds.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.a(ilv3DBounds.xMin, ilv3DBounds.yMin, ilv3DBounds.zMin, ilv3DBounds.xMax, ilv3DBounds.yMax, ilv3DBounds.zMax);
            return;
        }
        if (ilv3DBounds.xMin < this.xMin) {
            this.xMin = ilv3DBounds.xMin;
        }
        if (ilv3DBounds.yMin < this.yMin) {
            this.yMin = ilv3DBounds.yMin;
        }
        if (ilv3DBounds.zMin < this.zMin) {
            this.zMin = ilv3DBounds.zMin;
        }
        if (ilv3DBounds.xMax > this.xMax) {
            this.xMax = ilv3DBounds.xMax;
        }
        if (ilv3DBounds.yMax > this.yMax) {
            this.yMax = ilv3DBounds.yMax;
        }
        if (ilv3DBounds.zMax > this.zMax) {
            this.zMax = ilv3DBounds.zMax;
        }
    }

    public Ilv3DBounds compute(Ilv3DVector[] ilv3DVectorArray) {
        if (ilv3DVectorArray == null || ilv3DVectorArray.length == 0) {
            this.empty();
            return this;
        }
        this.xMin = this.xMax = ilv3DVectorArray[0].x;
        this.yMin = this.yMax = ilv3DVectorArray[0].y;
        this.zMin = this.zMax = ilv3DVectorArray[0].z;
        int n2 = ilv3DVectorArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            double d2 = ilv3DVectorArray[i2].x;
            if (d2 > this.xMax) {
                this.xMax = d2;
            } else if (d2 < this.xMin) {
                this.xMin = d2;
            }
            d2 = ilv3DVectorArray[i2].y;
            if (d2 > this.yMax) {
                this.yMax = d2;
            } else if (d2 < this.yMin) {
                this.yMin = d2;
            }
            d2 = ilv3DVectorArray[i2].z;
            if (d2 > this.zMax) {
                this.zMax = d2;
                continue;
            }
            if (!(d2 < this.zMin)) continue;
            this.zMin = d2;
        }
        return this;
    }

    public static Ilv3DBounds getBounds(Ilv3DVector[] ilv3DVectorArray) {
        return new Ilv3DBounds().compute(ilv3DVectorArray);
    }

    public void empty() {
        this.zMax = 0.0;
        this.yMax = 0.0;
        this.xMax = 0.0;
        this.zMin = 0.0;
        this.yMin = 0.0;
        this.xMin = 0.0;
    }

    public boolean isEmpty() {
        return this.getXExtents() == 0.0 && this.getYExtents() == 0.0 && this.getZExtents() == 0.0;
    }

    public double getXExtents() {
        return this.xMax - this.xMin;
    }

    public double getYExtents() {
        return this.yMax - this.yMin;
    }

    public double getZExtents() {
        return this.zMax - this.zMin;
    }

    public Rectangle2D getXYBounds(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(this.xMin, this.yMin, 0.0, 0.0);
        } else {
            rectangle2D.setRect(this.xMin, this.yMin, 0.0, 0.0);
        }
        rectangle2D.add(this.xMax, this.yMax);
        return rectangle2D;
    }

    public Ilv3DBounds transform(Ilv3DMatrix ilv3DMatrix) {
        Ilv3DVector[] ilv3DVectorArray = Ilv3DUtil.createCubeVertices(this.xMin, this.yMin, this.xMax, this.yMax, this.zMin, this.zMax, null);
        ilv3DMatrix.transform(ilv3DVectorArray, ilv3DVectorArray, ilv3DVectorArray.length);
        return Ilv3DBounds.getBounds(ilv3DVectorArray);
    }

    public String toString() {
        return "[" + this.xMin + ", " + this.yMin + ", " + this.zMin + ";  " + this.xMax + ", " + this.yMax + ", " + this.zMax + "]";
    }
}

