/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.util.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class IlvArrayPool {
    private static final Object a = new Object();
    private static double[][] b = new double[2][];
    private static final Object c = new Object();
    private static int[][] d = new int[2][];
    public static int SIZE_THRESHOLD = 129;
    private ReferenceQueue e = new ReferenceQueue();
    private ReferenceQueue f = new ReferenceQueue();
    private List g = new LinkedList();
    private List h = new LinkedList();
    private String i;

    public static final Object getDoubleCoordsLock() {
        return a;
    }

    public static double[][] allocDoubleCoords(int n2) {
        if (b[0] == null || b[0].length < n2) {
            IlvArrayPool.b[0] = new double[n2];
            IlvArrayPool.b[1] = new double[n2];
        }
        return b;
    }

    public static final Object getIntCoordsLock() {
        return c;
    }

    public static int[][] allocIntCoords(int n2) {
        if (d[0] == null || d[0].length < n2) {
            IlvArrayPool.d[0] = new int[n2];
            IlvArrayPool.d[1] = new int[n2];
        }
        return d;
    }

    IlvArrayPool(String string) {
        this(string, false);
    }

    IlvArrayPool(String string, boolean bl) {
        this.i = string;
        if (bl) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(2000L);
                            System.out.println(IlvArrayPool.this.toString());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            thread.start();
        }
    }

    protected abstract Object create(int var1);

    protected abstract int getSize(Object var1);

    public synchronized Object reAlloc(Object object, int n2, Object object2) {
        if (object == null) {
            return this.take(n2, object2);
        }
        int n3 = this.getSize(object);
        if (n3 >= n2) {
            return object;
        }
        n2 = IlvArrayPool.a(n2);
        Object object3 = this.take(n2, object2);
        System.arraycopy(object, 0, object3, 0, n3);
        this.release(object);
        return object3;
    }

    public synchronized Object take(int n2, Object object) {
        if (n2 < SIZE_THRESHOLD) {
            return this.create(n2);
        }
        this.checkQueue();
        ListIterator listIterator = this.g.listIterator();
        Block block = null;
        Block block2 = null;
        Block block3 = null;
        Object object2 = null;
        while (listIterator.hasNext()) {
            block = (Block)listIterator.next();
            if (block.size >= n2) {
                block2 = block;
                object2 = block.get();
                break;
            }
            if (block3 != null && block3.size >= block.size) continue;
            block3 = block;
        }
        if (object2 != null) {
            listIterator.remove();
        } else if (block2 != null) {
            listIterator.remove();
            object2 = this.create(n2);
            block2 = new Block(object2, n2);
        } else {
            if (block3 != null) {
                this.g.remove(block3);
            }
            object2 = this.create(n2);
            block2 = new Block(object2, n2);
        }
        block2.checkIn(object);
        this.h.add(block2);
        return object2;
    }

    public synchronized void release(Object object) {
        if (object == null || this.getSize(object) < SIZE_THRESHOLD) {
            return;
        }
        Block block = this.getBlock(object);
        if (block != null) {
            this.h.remove(block);
            this.g.add(block);
            block.checkOut();
        }
    }

    protected Block getBlock(Object object) {
        Block block = null;
        Iterator iterator = this.h.iterator();
        while (iterator.hasNext() && (block = (Block)iterator.next()).get() != object) {
        }
        return block;
    }

    public void checkQueue() {
        Reference reference = this.e.poll();
        while (reference != null) {
            if (!this.g.remove(reference)) {
                this.h.remove(reference);
            }
            reference = this.e.poll();
        }
        reference = this.f.poll();
        while (reference != null) {
            Iterator iterator = this.h.iterator();
            while (iterator.hasNext()) {
                Block block = (Block)iterator.next();
                if (block.borrower != reference) continue;
                iterator.remove();
                block.checkOut();
                this.g.add(block);
                reference.clear();
            }
            reference = this.f.poll();
        }
    }

    public synchronized String toString() {
        return this.i + " ---------------------------------------\n" + "Availables[" + this.g.size() + "]:\t" + this.g.toString() + "\nBorrowed[" + this.h.size() + "]:\t" + this.h.toString();
    }

    static int a(int n2) {
        int n3;
        if (n2 < 4) {
            return 4;
        }
        for (n3 = 4; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    private final class Block
    extends SoftReference {
        public int size;
        public PhantomReference borrower;

        Block(Object object, int n2) {
            super(object, IlvArrayPool.this.e);
            this.size = 0;
            this.size = n2;
        }

        public void checkIn(Object object) {
            if (object != null) {
                this.borrower = new PhantomReference<Object>(object, IlvArrayPool.this.f);
            }
        }

        public void checkOut() {
            this.borrower = null;
        }

        public String toString() {
            String string = "Block [" + this.size + "]";
            if (this.get() == null) {
                string = string + " (null)";
            }
            return string;
        }
    }
}

