/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvDefaultChartDataPicker;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.servlet.IlvChartServerAction;
import ilog.views.chart.servlet.IlvChartServerActionEvent;
import ilog.views.chart.servlet.IlvChartServletSupport;
import ilog.views.chart.servlet.IlvParameterException;
import ilog.views.chart.servlet.IlvServletRequestParameters;
import java.awt.Insets;
import java.awt.Point;
import javax.servlet.ServletException;

public class IlvPickPointAction
implements IlvChartServerAction {
    public static final int ITEM_PICKING = 1;
    public static final int NEAREST_POINT_PICKING = 2;
    private int a = 2;

    public final int getPickingMode() {
        return this.a;
    }

    public void setPickingMode(int n2) {
        this.a = n2;
    }

    protected IlvChartDataPicker createDataPicker(int n2, int n3) {
        return new IlvDefaultChartDataPicker(n2, n3, 5);
    }

    public void actionPerformed(IlvChartServerActionEvent ilvChartServerActionEvent) throws ServletException {
        IlvChart ilvChart = ilvChartServerActionEvent.getChart();
        if (ilvChart == null) {
            return;
        }
        Insets insets = ilvChart.getInsets();
        int n2 = ilvChartServerActionEvent.getIntParameter(0);
        int n3 = ilvChartServerActionEvent.getIntParameter(1);
        Point point = new Point(n2, n3);
        try {
            point = IlvChartServletSupport.toChartArea(point, new IlvServletRequestParameters(ilvChartServerActionEvent.getRequest()), ilvChartServerActionEvent.getChart());
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(point.x, point.y);
        ilvChart.toData(ilvDoublePoints);
        IlvDisplayPoint ilvDisplayPoint = this.pickData(ilvChart, point.x, point.y);
        if (ilvDisplayPoint != null) {
            this.pointSelected(ilvDisplayPoint);
        }
    }

    protected IlvDisplayPoint pickData(IlvChart ilvChart, int n2, int n3) {
        if (this.getPickingMode() == 1) {
            return ilvChart.getDisplayItem(this.createDataPicker(n2, n3));
        }
        return ilvChart.getNearestPoint(this.createDataPicker(n2, n3));
    }

    protected void pointSelected(IlvDisplayPoint ilvDisplayPoint) {
    }

    public int getExecutionThread() {
        return 1;
    }
}

