/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.print;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.print.IlvDefaultChartPrintContext;
import ilog.views.chart.print.IlvPrintableChart;
import ilog.views.chart.util.internal.IlvFlags;
import ilog.views.util.print.IlvFlow;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvPrintableDocument;
import ilog.views.util.print.IlvUnit;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class IlvChartPrintableDocument
extends IlvPrintableDocument {
    public static final int FIT_TO_DIMENSION = 0;
    public static final int SCALE_TO_DIMENSION = 1;
    public static final int XMIN_YMIN = 1;
    public static final int XMID_YMIN = 2;
    public static final int XMAX_YMIN = 3;
    public static final int XMIN_YMID = 4;
    public static final int XMID_YMID = 5;
    public static final int XMAX_YMID = 6;
    public static final int XMIN_YMAX = 7;
    public static final int XMID_YMAX = 8;
    public static final int XMAX_YMAX = 9;
    public static final float HIGH_RESOLUTION = 1.8f;
    public static final float MEDIUM_RESOLUTION = 1.4f;
    public static final float IDENTITY_RESOLUTION = 1.0f;
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private IlvChart d;
    private int e;
    private IlvDataWindow f;
    private int g = 0;
    private float h = 1.4f;
    private int i = 5;
    private IlvFlags j = new IlvFlags();

    public IlvChartPrintableDocument(String string, IlvChart ilvChart, PageFormat pageFormat) {
        this(string, ilvChart, false, 1, true, new IlvDataWindow(ilvChart.getXAxis().getDataRange(), ilvChart.getYAxis(0).getDataRange()), pageFormat);
    }

    public IlvChartPrintableDocument(String string, IlvChart ilvChart, boolean bl, int n2, boolean bl2, IlvDataWindow ilvDataWindow, PageFormat pageFormat) {
        super(string, pageFormat);
        if (ilvChart == null) {
            throw new IllegalArgumentException("chart must not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The number of pages must be greater than 0");
        }
        this.d = ilvChart;
        this.setRepeatYScales(bl);
        this.e = n2;
        this.f = ilvDataWindow;
        this.setPrintingChart(bl2);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("header") || string.equals("footer") || string.equals("pageFormat") || string.equals("pageOrder") || string.equals("multiPageCount") || string.equals("dataWindow") || string.equals("repeatYScales") || string.equals("printingChart") || string.equals("resizeMode") || string.equals("repeatTitle") || string.equals("resolutionScaleFactor") || string.equals("scalingAlignment")) {
                    IlvChartPrintableDocument.this.invalidatePages();
                }
            }
        });
    }

    public int getScalingAlignment() {
        return this.i;
    }

    public void setScalingAlignment(int n2) {
        this.a(n2);
        if (this.i != n2) {
            int n3 = this.i;
            this.i = n2;
            this.firePropertyChange("scalingAlignment", new Integer(n3), new Integer(n2));
        }
    }

    private void a(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Scaling Alignment value: " + n2);
    }

    public int getResizeMode() {
        return this.g;
    }

    public void setResizeMode(int n2) {
        IlvChartPrintableDocument.b(n2);
        if (this.g != n2) {
            int n3 = this.g;
            this.g = n2;
            this.firePropertyChange("resizeMode", new Integer(n3), new Integer(this.g));
        }
    }

    private static void b(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalide resize mode");
            }
        }
    }

    public IlvChart getChart() {
        return this.d;
    }

    public final boolean isPrintingChart() {
        return this.j.getFlag(2);
    }

    public void setPrintingChart(boolean bl) {
        if (this.isPrintingChart() != bl) {
            boolean bl2 = this.isPrintingChart();
            this.j.setFlag(2, bl);
            this.firePropertyChange("printingChart", new Boolean(bl2), new Boolean(bl));
        }
    }

    public IlvDataWindow getDataWindow() {
        return this.f;
    }

    public void setDataWindow(IlvDataWindow ilvDataWindow) {
        if (ilvDataWindow == null) {
            throw new IllegalArgumentException("dataWindow must not be null");
        }
        if (!this.f.equals(ilvDataWindow)) {
            IlvDataWindow ilvDataWindow2 = this.f;
            this.f = ilvDataWindow;
            this.firePropertyChange("dataWindow", ilvDataWindow2, this.f);
        }
    }

    public boolean getRepeatYScales() {
        return this.j.getFlag(1);
    }

    public void setRepeatYScales(boolean bl) {
        if (this.getRepeatYScales() != bl) {
            boolean bl2 = this.getRepeatYScales();
            this.j.setFlag(1, bl);
            this.firePropertyChange("repeatYScales", new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getRepeatTitle() {
        return this.j.getFlag(4);
    }

    public void setRepeatTitle(boolean bl) {
        if (this.getRepeatTitle() != bl) {
            boolean bl2 = this.getRepeatTitle();
            this.j.setFlag(4, bl);
            this.firePropertyChange("repeatTitle", new Boolean(bl2), new Boolean(bl));
        }
    }

    public int getMultiPageCount() {
        return this.e;
    }

    public void setMultiPageCount(int n2) {
        if (this.e != n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("The number of column must be greater than 0");
            }
            int n3 = this.e;
            this.e = n2;
            this.firePropertyChange("multiPageCount", new Integer(n3), new Integer(n2));
        }
    }

    public float getResolutionScaleFactor() {
        return this.h;
    }

    public void setResolutionScaleFactor(float f2) {
        if (this.h != f2) {
            float f3 = this.h;
            this.h = f2;
            this.firePropertyChange("resolutionScaleFactor", new Float(f3), new Float(this.h));
        }
    }

    protected IlvPage[] createPages() {
        ArrayList<IlvPage> arrayList = new ArrayList<IlvPage>();
        PageFormat pageFormat = this.getPageFormat();
        IlvUnit.Rectangle rectangle = this.getImageableBounds();
        for (int i2 = 0; i2 < this.getMultiPageCount(); ++i2) {
            IlvPage ilvPage = new IlvPage();
            IlvPrintableChart ilvPrintableChart = this.createPrintableChart(ilvPage, i2, rectangle);
            if (ilvPrintableChart != null) {
                ilvPage.addPrintableObject(ilvPrintableChart);
            }
            arrayList.add(ilvPage);
        }
        IlvPage[] ilvPageArray = new IlvPage[arrayList.size()];
        arrayList.toArray(ilvPageArray);
        return ilvPageArray;
    }

    protected IlvPrintableChart createPrintableChart(IlvPage ilvPage, int n2, IlvUnit.Rectangle rectangle) {
        IlvDataWindow ilvDataWindow = this.computeDataWindow(n2, 0);
        IlvDefaultChartPrintContext ilvDefaultChartPrintContext = new IlvDefaultChartPrintContext(ilvDataWindow, rectangle, this, ilvPage);
        return new IlvPrintableChart(this.d, rectangle, ilvDefaultChartPrintContext);
    }

    protected IlvDataWindow computeDataWindow(int n2, int n3) {
        IlvAxisTransformer ilvAxisTransformer = this.d.getXAxis().getTransformer();
        IlvDataInterval ilvDataInterval = new IlvDataInterval(this.f.xRange);
        if (ilvAxisTransformer != null) {
            try {
                ilvAxisTransformer.apply(ilvDataInterval);
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvAxisTransformerException.printStackTrace();
            }
        }
        double d2 = ilvDataInterval.getLength() / (double)this.getMultiPageCount();
        IlvDataWindow ilvDataWindow = new IlvDataWindow(ilvDataInterval.getMin() + (double)n2 * d2, ilvDataInterval.getMin() + (double)n2 * d2 + d2, this.f.yRange.getMin(), this.f.yRange.getMax());
        if (ilvAxisTransformer != null) {
            try {
                ilvAxisTransformer.inverse(ilvDataWindow.xRange);
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvAxisTransformerException.printStackTrace();
            }
        }
        return ilvDataWindow;
    }

    public IlvFlow getFlow() {
        throw new IllegalArgumentException("cannot use the flow of this document.");
    }
}

