/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.graphic;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.util.IlvGraphicUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

public class IlvDefaultDataAnnotation
implements IlvDataAnnotation,
SwingConstants,
Serializable {
    private Icon a;
    private int b;
    private int c;
    private URL d;

    public IlvDefaultDataAnnotation(URL uRL) {
        this(uRL, 0, 0);
    }

    public IlvDefaultDataAnnotation(URL uRL, int n2, int n3) {
        this(new ImageIcon(uRL), n2, n3);
        this.d = uRL;
    }

    public IlvDefaultDataAnnotation(Icon icon) {
        this(icon, 0, 0);
    }

    public IlvDefaultDataAnnotation(Icon icon, int n2, int n3) {
        this.a(icon);
        this.b = n2;
        this.c = n3;
    }

    void a(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Icon cannot be null");
        }
        this.a = icon;
    }

    public final IlvDefaultDataAnnotation setIcon(Icon icon) {
        return new IlvDefaultDataAnnotation(icon, this.b, this.c);
    }

    public final URL getURL() {
        return this.d;
    }

    public final Icon getIcon() {
        return this.a;
    }

    public final IlvDefaultDataAnnotation setOffset(int n2) {
        return new IlvDefaultDataAnnotation(this.a, this.b, n2);
    }

    public final int getOffset() {
        return this.c;
    }

    public final IlvDefaultDataAnnotation setPosition(int n2) {
        return new IlvDefaultDataAnnotation(this.a, n2, this.c);
    }

    public final int getPosition() {
        return this.b;
    }

    public void draw(Graphics graphics, IlvDisplayPoint ilvDisplayPoint) {
        Point point = this.computeIconLocation(ilvDisplayPoint);
        this.a.paintIcon(ilvDisplayPoint.getRenderer().getChart(), graphics, point.x, point.y);
    }

    public Rectangle2D getBounds(IlvDisplayPoint ilvDisplayPoint, Rectangle2D rectangle2D) {
        Point point = this.computeIconLocation(ilvDisplayPoint);
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(point.x, point.y, this.a.getIconWidth(), this.a.getIconHeight());
        } else {
            rectangle2D.setRect(point.x, point.y, this.a.getIconWidth(), this.a.getIconHeight());
        }
        return rectangle2D;
    }

    protected Point computeIconLocation(IlvDisplayPoint ilvDisplayPoint) {
        Point point = new Point(IlvGraphicUtil.toInt(ilvDisplayPoint.getXCoord()), IlvGraphicUtil.toInt(ilvDisplayPoint.getYCoord()));
        return IlvDefaultDataAnnotation.computeLocation(this.a, this.getPosition(), this.c, point);
    }

    public static Point computeLocation(Icon icon, int n2, int n3, Point point) {
        int n4 = icon.getIconWidth();
        int n5 = icon.getIconHeight();
        switch (n2) {
            case 1: {
                point.y -= n5 + n3;
                point.x -= n4 / 2;
                break;
            }
            case 2: {
                point.y -= n5 + n3;
                point.x += n3;
                break;
            }
            case 3: {
                point.y -= n5 / 2;
                point.x += n3;
                break;
            }
            case 4: {
                point.y += n3;
                point.x += n3;
                break;
            }
            case 5: {
                point.y += n3;
                point.x -= n4 / 2;
                break;
            }
            case 6: {
                point.y += n3;
                point.x -= n4 + n3;
                break;
            }
            case 7: {
                point.y -= n5 / 2;
                point.x -= n4 + n3;
                break;
            }
            case 8: {
                point.y -= n5 + n3;
                point.x -= n4 + n3;
                break;
            }
            default: {
                point.y = (int)((double)point.y - (double)n5 / 2.0);
                point.x = (int)((double)point.x - (double)n4 / 2.0);
            }
        }
        return point;
    }
}

