/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.data;

import ilog.views.chart.data.IlvCombinedDataSet;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetPropertyEvent;

public class IlvMovingAvgDataSet
extends IlvCombinedDataSet {
    static final int a = 5;
    private int b;

    public IlvMovingAvgDataSet() {
        this(5);
    }

    public IlvMovingAvgDataSet(int n2) {
        this.setMaxDataSetCount(1);
        this.setPeriod(n2);
    }

    public IlvMovingAvgDataSet(IlvDataSet ilvDataSet, int n2) {
        this(n2);
        this.addDataSet(ilvDataSet);
    }

    public String getName() {
        String string = super.getName();
        if (string != null) {
            return string;
        }
        if (this.getDataSetCount() == 1) {
            return this.getDataSet(0).getName() + " Mov. Avg.";
        }
        return null;
    }

    public boolean isXValuesSorted() {
        return this.getDataSetCount() > 0 ? this.getDataSet(0).isXValuesSorted() : true;
    }

    public int getPeriod() {
        return this.b;
    }

    public void setPeriod(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Period must be strictly positive");
        }
        this.b = n2;
        this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
    }

    public double getYData(int n2) {
        IlvDataSet ilvDataSet = this.getDataSet(0);
        double d2 = 0.0;
        int n3 = n2 + this.b;
        while (--n3 >= n2) {
            d2 += ilvDataSet.getYData(n3);
        }
        return d2 / (double)this.b;
    }

    public double getXData(int n2) {
        return this.getDataSet(0).getXData(n2 + this.b);
    }

    protected void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
        super.dataSetContentsChanged(dataSetContentsEvent);
        int n2 = this.getDataCount();
        if (n2 == 0) {
            return;
        }
        int n3 = Math.max(dataSetContentsEvent.getFirstIdx() - this.b, 0);
        int n4 = Math.min(dataSetContentsEvent.getLastIdx(), n2 - 1);
        if (dataSetContentsEvent.getType() == 1) {
            this.fireDataChangedEvent(n3, n4, 1);
        } else if (dataSetContentsEvent.getType() == 2) {
            this.fireDataChangedEvent(n3, n4, 2);
        } else if (dataSetContentsEvent.getType() == 4) {
            this.fireDataAddedEvent(n2 - 1, n2 - 1);
        }
    }

    protected void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
        this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, dataSetPropertyEvent));
    }

    protected int computeDataCount() {
        if (this.getDataSetCount() == 1) {
            return Math.max(0, this.getDataSet(0).getDataCount() - this.b);
        }
        return 0;
    }
}

