/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.action;

import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.action.IlvChartAction;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class IlvChartZoomAction
extends IlvChartAction {
    private double a;
    private boolean b = true;
    private boolean c = false;
    private AxisListener d = new AxisListener(){

        public void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
            IlvChartZoomAction.this.a(axisRangeEvent);
        }

        public void axisChanged(AxisChangeEvent axisChangeEvent) {
        }
    };

    public IlvChartZoomAction(String string) {
        this(string, null, null, null, null, 2.0);
    }

    public IlvChartZoomAction(String string, Icon icon) {
        this(string, icon, null, null, null, 2.0);
    }

    public IlvChartZoomAction(String string, double d2) {
        this(string, null, null, null, null, d2);
    }

    public IlvChartZoomAction(String string, Icon icon, double d2) {
        this(string, icon, null, null, null, d2);
    }

    public IlvChartZoomAction(String string, Icon icon, KeyStroke keyStroke, String string2, String string3, double d2) {
        super(string, icon, keyStroke, string2, string3);
        this.a = d2;
    }

    public double getZoomFactor() {
        return this.a;
    }

    public void setZoomFactor(double d2) {
        this.a = d2;
        if (this.getChart() != null) {
            this.attach();
        }
    }

    public final boolean isXZoomAllowed() {
        return this.b;
    }

    public void setXZoomAllowed(boolean bl) {
        this.b = bl;
    }

    public final boolean isYZoomAllowed() {
        return this.c;
    }

    public void setYZoomAllowed(boolean bl) {
        this.c = bl;
    }

    public final boolean isZoomIn() {
        return this.a >= 1.0;
    }

    protected void detach() {
        super.detach();
        if (!this.isZoomIn()) {
            this.getXAxis().removeAxisListener(this.d);
            this.getYAxis().removeAxisListener(this.d);
        }
    }

    protected void attach() {
        super.attach();
        if (!this.isZoomIn()) {
            this.getXAxis().addAxisListener(this.d);
            this.getYAxis().addAxisListener(this.d);
        }
    }

    protected void computeEnabled() {
        if (this.getChart() == null) {
            this.setEnabled(false);
        } else if (this.isZoomIn()) {
            this.setEnabled(true);
        } else {
            boolean bl = false;
            if (this.b) {
                boolean bl2 = bl = this.getXAxis().getDataRange().isStrictlyInside(this.getXAxis().getVisibleRange().getMin()) || this.getXAxis().getDataRange().isStrictlyInside(this.getXAxis().getVisibleRange().getMax());
            }
            if (!bl && this.c) {
                bl = this.getYAxis().getDataRange().isStrictlyInside(this.getYAxis().getVisibleRange().getMin()) || this.getYAxis().getDataRange().isStrictlyInside(this.getYAxis().getVisibleRange().getMax());
            }
            this.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d2;
        double d3;
        double d4;
        if (!this.isEnabled() || this.getChart() == null) {
            return;
        }
        IlvDataWindow ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        if (this.isXZoomAllowed()) {
            d4 = this.getXAxis().getVisibleRange().getLength() / this.a;
            d3 = this.getXAxis().getVisibleRange().getMiddle() - d4 / 2.0;
            d2 = this.getXAxis().getVisibleRange().getMiddle() + d4 / 2.0;
            ilvDataWindow.xRange.set(d3, d2);
        }
        if (this.isYZoomAllowed()) {
            d4 = this.getYAxis().getVisibleRange().getLength() / this.a;
            d3 = this.getYAxis().getVisibleRange().getMiddle() - d4 / 2.0;
            d2 = this.getYAxis().getVisibleRange().getMiddle() + d4 / 2.0;
            ilvDataWindow.yRange.set(d3, d2);
        }
        this.getChart().zoom(ilvDataWindow, this.getYAxisIndex());
    }

    void a(AxisRangeEvent axisRangeEvent) {
        if (axisRangeEvent.isAboutToChangeEvent()) {
            return;
        }
        this.computeEnabled();
    }
}

