/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.util.internal.IlvFlags;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public class IlvTimeStepsDefinition
extends IlvStepsDefinition {
    private static final IlvTimeUnit[] a = new IlvTimeUnit[]{IlvTimeUnit.SECOND, IlvTimeUnit.MINUTE, IlvTimeUnit.HOUR, IlvTimeUnit.DAY, IlvTimeUnit.WEEK, IlvTimeUnit.MONTH, IlvTimeUnit.QUARTER, IlvTimeUnit.YEAR, IlvTimeUnit.DECADE, IlvTimeUnit.CENTURY};
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    private static final int e = 1;
    private IlvFlags f = new IlvFlags(1);
    private DateFormat g;
    private Calendar h = null;
    private Calendar i = null;
    private IlvTimeUnit j = IlvTimeUnit.DAY;
    protected IlvTimeUnit[] autoUnits = a;
    static /* synthetic */ Class k;

    private IlvTimeUnit a(IlvTimeUnit ilvTimeUnit) {
        for (int i2 = 0; i2 < this.autoUnits.length; ++i2) {
            if (ilvTimeUnit != this.autoUnits[i2]) continue;
            return this.autoUnits[Math.min(i2 + 1, this.autoUnits.length - 1)];
        }
        return IlvTimeUnit.YEAR;
    }

    public IlvTimeStepsDefinition() {
        this.i();
        this.j();
    }

    final Calendar e() {
        return this.h;
    }

    final Calendar a(Date date) {
        this.i.setTime(date);
        return this.i;
    }

    final Calendar c(double d2) {
        return this.a(new Date((long)d2));
    }

    public final boolean isAutoUnit() {
        return this.f.getFlag(1);
    }

    public void setAutoUnit(boolean bl) {
        this.f.setFlag(1, bl);
    }

    public void setAutoUnits(IlvTimeUnit[] ilvTimeUnitArray) {
        if (ilvTimeUnitArray == null) {
            this.autoUnits = a;
        } else {
            this.autoUnits = new IlvTimeUnit[ilvTimeUnitArray.length];
            System.arraycopy(ilvTimeUnitArray, 0, this.autoUnits, 0, ilvTimeUnitArray.length);
            Arrays.sort(this.autoUnits, TimeUnitComparator.a());
        }
    }

    public IlvTimeUnit[] getAutoUnits() {
        IlvTimeUnit[] ilvTimeUnitArray = new IlvTimeUnit[this.autoUnits.length];
        System.arraycopy(this.autoUnits, 0, ilvTimeUnitArray, 0, this.autoUnits.length);
        return ilvTimeUnitArray;
    }

    final boolean f() {
        return this.f.getFlag(2);
    }

    void a(boolean bl) {
        this.f.setFlag(2, bl);
    }

    public final IlvTimeUnit getUnit() {
        return this.j;
    }

    public void setUnit(IlvTimeUnit ilvTimeUnit) {
        this.setAutoUnit(false);
        this.b(ilvTimeUnit);
    }

    private void b(IlvTimeUnit ilvTimeUnit) {
        if (this.j == ilvTimeUnit) {
            return;
        }
        this.j = ilvTimeUnit;
        this.j();
    }

    public void update() {
        if (this.getScale() == null) {
            this.setUnit(IlvTimeUnit.DAY);
            return;
        }
        if (this.isAutoUnit()) {
            this.l();
        } else if (this.f()) {
            this.g();
        }
    }

    private void l() {
        this.b(this.computeTimeUnit());
    }

    protected IlvTimeUnit computeTimeUnit() {
        FontMetrics fontMetrics = this.getScale().a(this.getScale().getLabelFont());
        double d2 = this.b().getVisibleMax() - this.b().getVisibleMin();
        Date date = new Date((long)this.b().getVisibleMax());
        double d3 = Double.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        int n3 = this.autoUnits.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            IlvTimeUnit ilvTimeUnit = this.autoUnits[i2];
            double d4 = ilvTimeUnit.getMillis();
            double d5 = d2 / d4;
            if (d5 < 0.1 || d5 > 200.0) continue;
            simpleDateFormat.applyPattern(ilvTimeUnit.getFormatString());
            String string = this.a(simpleDateFormat, ilvTimeUnit, this.b().getVisibleMax());
            int n4 = this.getScale().a(fontMetrics.stringWidth(string), fontMetrics.getHeight(), 6);
            double d6 = Math.abs(d5 - (double)n4) / (double)n4;
            if (!(d6 < d3)) continue;
            n2 = i2;
            d3 = d6;
        }
        if (n2 < n3) {
            return this.autoUnits[n2];
        }
        return IlvTimeUnit.YEAR;
    }

    void g() {
        IlvScale ilvScale = this.getScale().j();
        if (ilvScale != null) {
            IlvTimeStepsDefinition ilvTimeStepsDefinition = (IlvTimeStepsDefinition)ilvScale.getStepsDefinition();
            this.setUnit(this.a(ilvTimeStepsDefinition.getUnit()));
        }
    }

    public double previousStep(double d2) {
        return this.j.previousUnitTime(this.c(d2)).getTime().getTime();
    }

    public double incrementStep(double d2) {
        return this.j.incrementTime(this.c(d2)).getTime().getTime();
    }

    DateFormat h() {
        return this.g;
    }

    void a(DateFormat dateFormat) {
        this.g = dateFormat;
    }

    void i() {
        this.h = this.getScale() != null && this.getScale().getChart() != null ? Calendar.getInstance(this.getScale().getChart().getLocale()) : Calendar.getInstance();
        this.i = (Calendar)this.h.clone();
    }

    void j() {
        this.g = this.getScale() != null && this.getScale().getChart() != null ? new SimpleDateFormat(this.j.getFormatString(), this.getScale().getChart().getLocale()) : new SimpleDateFormat(this.j.getFormatString());
    }

    final void k() {
        this.i();
        this.j();
    }

    public String computeLabel(double d2) {
        return this.a(this.h(), this.j, d2);
    }

    static final Date d(double d2) {
        return new Date((long)d2);
    }

    private final String a(DateFormat dateFormat, IlvTimeUnit ilvTimeUnit, double d2) {
        return ilvTimeUnit.format(dateFormat, this.c(d2));
    }

    private static class TimeUnitComparator
    implements Comparator {
        static TimeUnitComparator a = null;

        private TimeUnitComparator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static TimeUnitComparator a() {
            if (a == null) {
                Class clazz = k == null ? (k = IlvTimeStepsDefinition.class$("ilog.views.chart.IlvTimeStepsDefinition$TimeUnitComparator")) : k;
                synchronized (clazz) {
                    if (a == null) {
                        a = new TimeUnitComparator();
                    }
                }
            }
            return a;
        }

        public int compare(Object object, Object object2) {
            double d2;
            double d3 = ((IlvTimeUnit)object).getMillis();
            return d3 < (d2 = ((IlvTimeUnit)object2).getMillis()) ? -1 : 1;
        }
    }
}

