/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.SERBasicStroke;
import ilog.views.chart.graphic.IlvMarker;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvArrayPool;
import ilog.views.chart.util.internal.IlvDrawingPolygon2D;
import ilog.views.chart.util.internal.IlvIntArrayPool;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.java2d.IlvLinearGradientPaint;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvRadialGradientPaint;
import ilog.views.util.java2d.IlvTexture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;

public class IlvStyle
implements Cloneable,
Serializable {
    private static final Object a = new Boolean(true);
    private static final Object b = new Boolean(false);
    private static final RenderingHints.Key c = Drawing2DHintKey.a();
    private static boolean d = true;
    private static boolean e = false;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f, 0, 2);
    public static final Paint DEFAULT_STROKEPAINT = Color.black;
    public static final Paint DEFAULT_FILLPAINT = Color.gray;
    private static final int f = 100;
    static final HashMap g = new HashMap();
    static final HashMap h = new HashMap();
    private transient Stroke i;
    private transient Paint j;
    private transient Paint k;
    private boolean l = true;
    private boolean m = true;
    private boolean n = true;
    private boolean o = true;
    private boolean p = true;
    private transient Rectangle2D q = new Rectangle2D.Double();
    static final int r = 0;
    static final int s = 1;
    static final int t = 2;
    static final int u = 3;

    static void a(Graphics graphics, boolean bl) {
        ((Graphics2D)graphics).setRenderingHint(c, bl ? a : b);
    }

    static boolean a(Graphics graphics) {
        return ((Graphics2D)graphics).getRenderingHint(c) == a;
    }

    private static Line2D c(double d2, double d3, double d4, double d5) {
        return new Line2D.Double(d2, d3, d4, d5);
    }

    private static Ellipse2D d(double d2, double d3, double d4, double d5) {
        return new Ellipse2D.Double(d2, d3, d4, d5);
    }

    private static Rectangle2D e(double d2, double d3, double d4, double d5) {
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    public IlvStyle() {
        this(DEFAULT_STROKE, DEFAULT_STROKEPAINT, DEFAULT_FILLPAINT);
    }

    public IlvStyle(Paint paint, Paint paint2) {
        this(DEFAULT_STROKE, paint, paint2);
    }

    public IlvStyle(Stroke stroke, Paint paint) {
        this(stroke, paint, DEFAULT_FILLPAINT);
        this.l = false;
    }

    public IlvStyle(float f2, Paint paint) {
        this(new BasicStroke(f2, 1, 1), paint);
    }

    public IlvStyle(Paint paint) {
        this(DEFAULT_STROKE, DEFAULT_STROKEPAINT, paint);
        this.m = false;
    }

    public IlvStyle(Stroke stroke, Paint paint, Paint paint2) {
        this.a(stroke);
        this.a(paint);
        this.b(paint2);
    }

    public static IlvStyle createStroked(Paint paint) {
        return new IlvStyle(DEFAULT_STROKE, paint);
    }

    public final boolean isAbsolutePaint() {
        return this.p;
    }

    public void setAbsolutePaint(boolean bl) {
        this.p = bl;
    }

    final Paint a(double d2, double d3, double d4, double d5) {
        if (this.p) {
            return this.k;
        }
        return this.a(this.k, d2, d3, d4, d5);
    }

    final Paint b(double d2, double d3, double d4, double d5) {
        if (this.p) {
            return this.j;
        }
        return this.a(this.j, d2, d3, d4, d5);
    }

    public final boolean isStrokeOn() {
        return this.m;
    }

    public final boolean isFillOn() {
        return this.l;
    }

    public IlvStyle setStrokeOn(boolean bl) {
        if (bl == this.m) {
            return this;
        }
        IlvStyle ilvStyle = this.copy();
        ilvStyle.m = bl;
        return ilvStyle;
    }

    public IlvStyle setFillOn(boolean bl) {
        if (bl == this.l) {
            return this;
        }
        IlvStyle ilvStyle = this.copy();
        ilvStyle.l = bl;
        return ilvStyle;
    }

    public Stroke getStroke() {
        return this.i;
    }

    public Paint getStrokePaint() {
        return this.j;
    }

    public Color getStrokeColor() {
        return this.o ? (Color)this.j : null;
    }

    public Paint getFillPaint() {
        return this.k;
    }

    public Color getFillColor() {
        return this.n ? (Color)this.k : null;
    }

    public IlvStyle setStroke(Stroke stroke) {
        IlvStyle ilvStyle = this.copy();
        ilvStyle.a(stroke);
        return ilvStyle;
    }

    final void a(Stroke stroke) {
        if (stroke == null) {
            this.i = DEFAULT_STROKE;
            this.m = false;
        } else {
            this.i = stroke;
        }
    }

    public IlvStyle setStrokePaint(Paint paint) {
        IlvStyle ilvStyle = this.copy();
        ilvStyle.a(paint);
        return ilvStyle;
    }

    final void a(Paint paint) {
        this.j = paint == null ? DEFAULT_STROKEPAINT : paint;
        this.o = this.j instanceof Color;
    }

    public IlvStyle setStroke(Stroke stroke, Paint paint) {
        IlvStyle ilvStyle = this.copy();
        ilvStyle.a(paint);
        ilvStyle.a(stroke);
        return ilvStyle;
    }

    public IlvStyle setFillPaint(Paint paint) {
        IlvStyle ilvStyle = this.copy();
        ilvStyle.b(paint);
        return ilvStyle;
    }

    void b(Paint paint) {
        this.k = paint == null ? DEFAULT_FILLPAINT : paint;
        this.n = this.k instanceof Color;
    }

    public void applyStroke(Graphics graphics) {
        g.put(graphics, ((Graphics2D)graphics).getStroke());
        h.put(graphics, ((Graphics2D)graphics).getPaint());
        ((Graphics2D)graphics).setStroke(this.i);
        ((Graphics2D)graphics).setPaint(this.j);
    }

    public void restoreStroke(Graphics graphics) {
        Paint paint;
        Stroke stroke = (Stroke)g.remove(graphics);
        if (stroke != null) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        if ((paint = (Paint)h.remove(graphics)) != null) {
            ((Graphics2D)graphics).setPaint(paint);
        }
    }

    private Paint a(Paint paint, double d2, double d3, double d4, double d5) {
        if (paint instanceof Color) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            double d6;
            double d7;
            double d8;
            double d9;
            GradientPaint gradientPaint = (GradientPaint)paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            boolean bl = gradientPaint.isCyclic();
            if (point2D.getX() == point2D2.getX()) {
                d8 = d9 = d2 + d4 / 2.0;
                if (point2D.getY() > point2D2.getY()) {
                    d7 = d3 + d5;
                    d6 = bl ? d3 + d5 / 2.0 : d3;
                } else {
                    d7 = d3;
                    d6 = bl ? d3 + d5 / 2.0 : d3 + d5;
                }
            } else if (point2D.getY() == point2D2.getY()) {
                d6 = d7 = d3 + d5 / 2.0;
                if (point2D.getX() > point2D2.getX()) {
                    d9 = d2 + d4;
                    d8 = bl ? d2 + d4 / 2.0 : d2;
                } else {
                    d9 = d2;
                    d8 = bl ? d2 + d4 / 2.0 : d2 + d4;
                }
            } else if (point2D.getX() > point2D2.getX()) {
                d9 = d2 + d4;
                d8 = bl ? d2 + d4 / 2.0 : d2;
                if (point2D.getY() > point2D2.getY()) {
                    d7 = d3 + d5;
                    d6 = bl ? d3 + d5 / 2.0 : d3;
                } else {
                    d7 = d3;
                    d6 = bl ? d3 + d5 / 2.0 : d3 + d5;
                }
            } else {
                d9 = d2;
                d8 = bl ? d2 + d4 / 2.0 : d2 + d4;
                if (point2D.getY() > point2D2.getY()) {
                    d7 = d3 + d5;
                    d6 = bl ? d3 + d5 / 2.0 : d3;
                } else {
                    d7 = d3;
                    d6 = bl ? d3 + d5 / 2.0 : d3 + d5;
                }
            }
            point2D.setLocation(d9, d7);
            point2D2.setLocation(d8, d6);
            return new GradientPaint(point2D, gradientPaint.getColor1(), point2D2, gradientPaint.getColor2(), gradientPaint.isCyclic());
        }
        if (paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)paint;
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            rectangle2D.setRect(d2, d3, rectangle2D.getWidth(), rectangle2D.getHeight());
            return new TexturePaint(texturePaint.getImage(), rectangle2D);
        }
        return paint;
    }

    public void renderRect(Graphics graphics, double d2, double d3, double d4, double d5) {
        int n2 = 1;
        int n3 = 1;
        int n4 = IlvGraphicUtil.toInt(d2);
        int n5 = IlvGraphicUtil.toInt(d3);
        int n6 = IlvGraphicUtil.toInt(d4);
        int n7 = IlvGraphicUtil.toInt(d5);
        if (n6 < n4) {
            n2 = n4 - n6;
            n4 = n6;
        } else if (n6 > n4) {
            n2 = n6 - n4;
        }
        if (n7 < n5) {
            n3 = n5 - n7;
            n5 = n7;
        } else if (n7 > n5) {
            n3 = n7 - n5;
        }
        this.renderRect(graphics, n4, n5, n2, n3);
    }

    public void renderRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.isFillOn()) {
            this.fillRect(graphics, n2, n3, n4, n5);
        }
        if (this.isStrokeOn()) {
            this.drawRect(graphics, n2, n3, n4, n5);
        }
    }

    public void renderSquare(Graphics graphics, int n2, int n3, int n4) {
        n2 -= n4;
        n3 -= n4;
        n4 <<= 1;
        if (this.isFillOn()) {
            this.fillRect(graphics, n2, n3, n4 + 1, n4 + 1);
        }
        if (this.isStrokeOn()) {
            this.drawRect(graphics, n2, n3, n4, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPoints(Graphics graphics, double[] dArray, double[] dArray2, int n2) {
        if (IlvStyle.a(graphics)) {
            Object object = IlvDrawingPolygon2D.getClassLock();
            synchronized (object) {
                this.renderShape(graphics, IlvDrawingPolygon2D.getInstance(dArray, dArray2, n2, this.isFillOn()));
            }
        }
        Object object = IlvArrayPool.getIntCoordsLock();
        synchronized (object) {
            int[][] nArray = IlvArrayPool.allocIntCoords(n2);
            n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray[0], nArray[1], n2 > 100 && d);
            this.renderPoints(graphics, nArray[0], nArray[1], n2);
        }
    }

    public void renderPoints(Graphics graphics, int[] nArray, int[] nArray2, int n2) {
        if (this.isFillOn()) {
            this.fillPolygon(graphics, nArray, nArray2, n2);
        }
        if (this.isStrokeOn()) {
            this.drawPolyline(graphics, nArray, nArray2, n2);
        }
    }

    public void renderOval(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.isFillOn()) {
            this.fillOval(graphics, n2, n3, n4, n5);
        }
        if (this.isStrokeOn()) {
            this.drawOval(graphics, n2, n3, n4, n5);
        }
    }

    public void renderCircle(Graphics graphics, int n2, int n3, int n4) {
        n2 -= n4;
        n3 -= n4;
        n4 <<= 1;
        if (this.isFillOn()) {
            this.fillOval(graphics, n2, n3, n4 + 1, n4 + 1);
        }
        if (this.isStrokeOn()) {
            this.drawOval(graphics, n2, n3, n4, n4);
        }
    }

    public void renderShape(Graphics graphics, Shape shape) {
        if (this.isFillOn()) {
            this.fill(graphics, shape);
        }
        if (this.isStrokeOn()) {
            this.draw(graphics, shape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(Graphics graphics, double[] dArray, double[] dArray2, int n2) {
        if (IlvStyle.a(graphics)) {
            Object object = IlvDrawingPolygon2D.getClassLock();
            synchronized (object) {
                boolean bl = n2 > 1 && dArray[0] == dArray[n2 - 1] && dArray2[0] == dArray2[n2 - 1];
                this.draw(graphics, IlvDrawingPolygon2D.getInstance(dArray, dArray2, n2, bl));
            }
        }
        Object object = IlvArrayPool.getIntCoordsLock();
        synchronized (object) {
            int[][] nArray = IlvArrayPool.allocIntCoords(n2);
            n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray[0], nArray[1], n2 > 100 && d);
            this.drawPolyline(graphics, nArray[0], nArray[1], n2);
        }
    }

    public void drawPolyline(Graphics graphics, double[] dArray, double[] dArray2, int n2, IlvMarker ilvMarker, int n3) {
        int[] nArray = IlvIntArrayPool.take(n2);
        int[] nArray2 = IlvIntArrayPool.take(n2);
        n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray, nArray2, n2 > 100 && d);
        this.drawPolyline(graphics, nArray, nArray2, n2);
        if (ilvMarker != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvMarker.draw(graphics, nArray[i2], nArray2[i2], n3, this);
            }
        }
        IlvIntArrayPool.release(nArray);
        IlvIntArrayPool.release(nArray2);
    }

    public void drawPolyline(Graphics graphics, int[] nArray, int[] nArray2, int n2) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.o) {
            graphics2D.setColor((Color)this.j);
        } else {
            this.q = this.getBounds(nArray, nArray2, n2, this.q);
            graphics2D.setPaint(this.b(this.q.getX(), this.q.getY(), this.q.getWidth(), this.q.getHeight()));
        }
        graphics2D.setStroke(this.i);
        graphics2D.drawPolyline(nArray, nArray2, n2);
        graphics2D.setStroke(stroke);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(Graphics graphics, double[] dArray, double[] dArray2, int n2) {
        if (IlvStyle.a(graphics)) {
            Object object = IlvDrawingPolygon2D.getClassLock();
            synchronized (object) {
                this.fill(graphics, IlvDrawingPolygon2D.getInstance(dArray, dArray2, n2, true));
            }
        }
        Object object = IlvArrayPool.getIntCoordsLock();
        synchronized (object) {
            int[][] nArray = IlvArrayPool.allocIntCoords(n2);
            n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray[0], nArray[1], n2 > 100 && d);
            this.fillPolygon(graphics, nArray[0], nArray[1], n2);
        }
    }

    public void fillPolygon(Graphics graphics, int[] nArray, int[] nArray2, int n2) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.n) {
            graphics2D.setColor((Color)this.k);
        } else {
            this.q = this.getBounds(nArray, nArray2, n2, this.q);
            graphics2D.setPaint(this.a(this.q.getX(), this.q.getY(), this.q.getWidth(), this.q.getHeight()));
        }
        graphics2D.fillPolygon(nArray, nArray2, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void drawRect(Graphics graphics, double d2, double d3, double d4, double d5) {
        if (IlvStyle.a(graphics)) {
            this.draw(graphics, IlvStyle.e(d2, d3, d4, d5));
        } else {
            this.drawRect(graphics, IlvGraphicUtil.toInt(d2), IlvGraphicUtil.toInt(d3), IlvGraphicUtil.toInt(d4), IlvGraphicUtil.toInt(d5));
        }
    }

    public void drawRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.o) {
            graphics2D.setColor((Color)this.j);
        } else {
            graphics2D.setPaint(this.b(n2, n3, n4, n5));
        }
        graphics2D.setStroke(this.i);
        graphics2D.drawRect(n2, n3, n4, n5);
        graphics2D.setStroke(stroke);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void fillRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.n) {
            graphics2D.setColor((Color)this.k);
        } else {
            graphics2D.setPaint(this.a(n2, n3, n4, n5));
        }
        graphics2D.fillRect(n2, n3, n4, n5);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void drawLine(Graphics graphics, double d2, double d3, double d4, double d5) {
        if (IlvStyle.a(graphics)) {
            this.draw(graphics, IlvStyle.c(d2, d3, d4, d5));
        } else {
            this.drawLine(graphics, IlvGraphicUtil.toInt(d2), IlvGraphicUtil.toInt(d3), IlvGraphicUtil.toInt(d4), IlvGraphicUtil.toInt(d5));
        }
    }

    public void drawLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.o) {
            graphics2D.setColor((Color)this.j);
        } else if (this.p) {
            graphics2D.setPaint(this.j);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            if (n2 < n4) {
                n9 = n2;
                n8 = n4 - n2;
            } else {
                n9 = n4;
                n8 = n2 - n4;
            }
            if (n3 < n5) {
                n7 = n3;
                n6 = n5 - n3;
            } else {
                n7 = n5;
                n6 = n3 - n5;
            }
            graphics2D.setPaint(this.b(n9, n7, n8, n6));
        }
        graphics2D.setStroke(this.i);
        graphics2D.drawLine(n2, n3, n4, n5);
        graphics2D.setStroke(stroke);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void drawOval(Graphics graphics, double d2, double d3, double d4, double d5) {
        if (IlvStyle.a(graphics)) {
            this.draw(graphics, IlvStyle.d(d2, d3, d4, d5));
        } else {
            this.drawOval(graphics, IlvGraphicUtil.toInt(d2), IlvGraphicUtil.toInt(d3), IlvGraphicUtil.toInt(d4), IlvGraphicUtil.toInt(d5));
        }
    }

    public void drawOval(Graphics graphics, int n2, int n3, int n4, int n5) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.o) {
            graphics2D.setColor((Color)this.j);
        } else {
            graphics2D.setPaint(this.b(n2, n3, n4, n5));
        }
        graphics2D.setStroke(this.i);
        graphics2D.drawOval(n2, n3, n4, n5);
        graphics2D.setStroke(stroke);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void fillOval(Graphics graphics, double d2, double d3, double d4, double d5) {
        if (IlvStyle.a(graphics)) {
            this.fill(graphics, IlvStyle.d(d2, d3, d4, d5));
        } else {
            this.fillOval(graphics, IlvGraphicUtil.toInt(d2), IlvGraphicUtil.toInt(d3), IlvGraphicUtil.toInt(d4), IlvGraphicUtil.toInt(d5));
        }
    }

    public void fillOval(Graphics graphics, int n2, int n3, int n4, int n5) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.n) {
            graphics2D.setColor((Color)this.k);
        } else {
            graphics2D.setPaint(this.a(n2, n3, n4, n5));
        }
        graphics2D.fillOval(n2, n3, n4, n5);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void draw(Graphics graphics, Shape shape) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint2 = paint = e ? graphics2D.getPaint() : null;
        if (this.o) {
            graphics2D.setColor((Color)this.j);
        } else {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(this.b(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
        graphics2D.setStroke(this.i);
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    public void fill(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = null;
        if (e) {
            paint = graphics2D.getPaint();
        }
        if (this.n) {
            graphics2D.setColor((Color)this.k);
        } else {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(this.a(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
        graphics2D.fill(shape);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
    }

    float a() {
        return this.i instanceof BasicStroke ? ((BasicStroke)this.i).getLineWidth() : 0.0f;
    }

    public boolean quickBounds() {
        return this.i == DEFAULT_STROKE || this.i instanceof BasicStroke;
    }

    public void expand(Rectangle2D rectangle2D) {
        if (this.quickBounds()) {
            BasicStroke basicStroke = (BasicStroke)this.i;
            double d2 = basicStroke.getLineWidth();
            if (d2 > 1.0) {
                if (basicStroke.getLineJoin() == 0) {
                    d2 *= (double)(basicStroke.getMiterLimit() / 2.0f);
                }
                IlvGraphicUtil.grow(rectangle2D, d2, d2);
            }
        } else {
            Shape shape = this.i.createStrokedShape(rectangle2D);
            rectangle2D.setRect(shape.getBounds2D());
        }
    }

    public Rectangle2D getBounds(int[] nArray, int[] nArray2, int n2, Rectangle2D rectangle2D) {
        if (this.quickBounds()) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle();
            } else {
                rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvGraphicUtil.addToRect(rectangle2D, (double)nArray[i2], (double)nArray2[i2]);
            }
            this.expand(rectangle2D);
        } else {
            Polygon polygon = new Polygon(nArray, nArray2, n2);
            rectangle2D = this.getShapeBounds(polygon);
        }
        return rectangle2D;
    }

    public Rectangle2D getBounds(double[] dArray, double[] dArray2, int n2, Rectangle2D rectangle2D) {
        if (n2 == 0) {
            rectangle2D = new Rectangle2D.Double();
        } else if (this.quickBounds()) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double(dArray[0], dArray2[0], 1.0, 1.0);
            } else {
                rectangle2D.setRect(dArray[0], dArray2[0], 1.0, 1.0);
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                rectangle2D.add(dArray[i2], dArray2[i2]);
            }
            this.expand(rectangle2D);
        } else {
            rectangle2D = this.getShapeBounds(this.a(dArray, dArray2, n2));
        }
        return rectangle2D;
    }

    public Rectangle2D getShapeBounds(Shape shape) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2 = rectangle2D = this.i != DEFAULT_STROKE ? this.i.createStrokedShape(shape).getBounds2D() : shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() != 0.0 ? rectangle2D.getWidth() : 1.0, rectangle2D.getHeight() != 0.0 ? rectangle2D.getHeight() : 1.0);
        }
        return rectangle2D;
    }

    public IlvStyle brighther() {
        if (this.isFillOn() && this.n) {
            return this.setFillPaint(IlvColorUtil.brighter((Color)this.k));
        }
        if (this.isStrokeOn() && this.o) {
            return this.setStrokePaint(IlvColorUtil.brighter((Color)this.j));
        }
        return this;
    }

    public IlvStyle brighter() {
        if (this.isFillOn() && this.n) {
            return this.setFillPaint(IlvColorUtil.brighter((Color)this.k));
        }
        if (this.isStrokeOn() && this.o) {
            return this.setStrokePaint(IlvColorUtil.brighter((Color)this.j));
        }
        return this;
    }

    public IlvStyle darker() {
        if (this.isFillOn() && this.n) {
            return this.setFillPaint(IlvColorUtil.darker((Color)this.k));
        }
        if (this.isStrokeOn() && this.o) {
            return this.setStrokePaint(IlvColorUtil.darker((Color)this.j));
        }
        return this;
    }

    public boolean pointsContains(double[] dArray, double[] dArray2, int n2, double d2, double d3) {
        boolean bl = false;
        if (this.isFillOn()) {
            bl = this.polygonContains(dArray, dArray2, n2, d2, d3);
        }
        if (!bl && this.isStrokeOn()) {
            bl = this.polylineContains(dArray, dArray2, n2, d2, d3);
        }
        return bl;
    }

    public boolean polygonContains(double[] dArray, double[] dArray2, int n2, double d2, double d3) {
        boolean bl = false;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 < n2) {
            double d4 = dArray[n3];
            double d5 = dArray2[n3];
            double d6 = dArray[n4];
            double d7 = dArray2[n4];
            if (d5 <= d3 && d3 < d7 && (d7 - d5) * (d2 - d4) < (d6 - d4) * (d3 - d5) || d7 <= d3 && d3 < d5 && (d7 - d5) * (d2 - d4) > (d6 - d4) * (d3 - d5)) {
                bl ^= true;
            }
            n4 = n3++;
        }
        return bl;
    }

    public boolean polylineContains(double[] dArray, double[] dArray2, int n2, double d2, double d3) {
        if (this.a() < 4.0f) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - 2.0, d3 - 2.0, 4.0, 4.0);
            return this.i.createStrokedShape(this.a(dArray, dArray2, n2)).intersects(double_);
        }
        return this.a(this.a(dArray, dArray2, n2), d2, d3);
    }

    public boolean shapeContains(Shape shape, double d2, double d3) {
        boolean bl = false;
        if (this.isFillOn()) {
            bl = shape.contains(d2, d3);
        }
        if (!bl && this.isStrokeOn()) {
            bl = this.a(shape, d2, d3);
        }
        return bl;
    }

    private final boolean a(Shape shape, double d2, double d3) {
        shape = this.i.createStrokedShape(shape);
        if (this.a() < 4.0f) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - 2.0, d3 - 2.0, 4.0, 4.0);
            return shape.intersects(double_);
        }
        return shape.contains(d2, d3);
    }

    private Shape a(double[] dArray, double[] dArray2, int n2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            generalPath.lineTo((float)dArray[i2], (float)dArray2[i2]);
        }
        return generalPath;
    }

    public static final boolean isFilterOn() {
        return d;
    }

    public static void setFilterOn(boolean bl) {
        d = bl;
    }

    public IlvStyle copy() {
        return (IlvStyle)this.clone();
    }

    public void copyInto(IlvStyle ilvStyle) {
        ilvStyle.i = this.i;
        ilvStyle.j = this.j;
        ilvStyle.k = this.k;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IlvStyle)) {
            return false;
        }
        IlvStyle ilvStyle = (IlvStyle)object;
        return this.isFillOn() == ilvStyle.isFillOn() && this.isStrokeOn() == ilvStyle.isStrokeOn() && this.i.equals(ilvStyle.i) && this.j.equals(ilvStyle.j) && this.k.equals(ilvStyle.k);
    }

    private static void a(ObjectOutputStream objectOutputStream, Paint paint) throws IOException {
        if (paint instanceof Serializable) {
            objectOutputStream.writeInt(0);
            objectOutputStream.writeObject(paint);
        } else if (paint instanceof IlvPattern) {
            objectOutputStream.writeInt(1);
            IlvPattern ilvPattern = (IlvPattern)paint;
            objectOutputStream.writeInt(ilvPattern.getType());
            objectOutputStream.writeObject(ilvPattern.getForeground());
            objectOutputStream.writeObject(ilvPattern.getBackground());
        } else if (paint instanceof IlvTexture) {
            objectOutputStream.writeInt(2);
            IlvTexture ilvTexture = (IlvTexture)paint;
            URL uRL = ilvTexture.getImageURL();
            objectOutputStream.writeObject(uRL);
            Rectangle2D rectangle2D = ilvTexture.getAnchorRect();
            objectOutputStream.writeDouble(rectangle2D.getX());
            objectOutputStream.writeDouble(rectangle2D.getY());
            objectOutputStream.writeDouble(rectangle2D.getWidth());
            objectOutputStream.writeDouble(rectangle2D.getHeight());
        } else {
            objectOutputStream.writeInt(3);
            objectOutputStream.writeObject(null);
        }
    }

    private Paint a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = objectInputStream.readInt();
        switch (n2) {
            case 0: {
                return (Paint)objectInputStream.readObject();
            }
            case 1: {
                int n3 = objectInputStream.readInt();
                Color color = (Color)objectInputStream.readObject();
                Color color2 = (Color)objectInputStream.readObject();
                return new IlvPattern(n3, color, color2);
            }
            case 2: {
                URL uRL = (URL)objectInputStream.readObject();
                double d2 = objectInputStream.readDouble();
                double d3 = objectInputStream.readDouble();
                double d4 = objectInputStream.readDouble();
                double d5 = objectInputStream.readDouble();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
                return new IlvTexture(uRL, (Rectangle2D)double_);
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        IlvStyle.a(objectOutputStream, this.j);
        IlvStyle.a(objectOutputStream, this.k);
        if (this.i instanceof Serializable) {
            objectOutputStream.writeObject(this.i);
        } else if (this.i instanceof BasicStroke) {
            objectOutputStream.writeObject(new SERBasicStroke((BasicStroke)this.i));
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.j = this.a(objectInputStream);
        this.k = this.a(objectInputStream);
        Object object = objectInputStream.readObject();
        if (object == null) {
            object = DEFAULT_STROKE;
        } else if (object instanceof SERBasicStroke) {
            object = ((SERBasicStroke)object).a();
        }
        this.i = (Stroke)object;
    }

    public static class IntensityChange
    extends ColorChange {
        private int a;

        public IntensityChange(int n2) {
            this.a = n2;
        }

        protected Color changeColor(Color color) {
            block3: {
                block2: {
                    if (this.a <= 0) break block2;
                    for (int i2 = 0; i2 < this.a; ++i2) {
                        color = IlvColorUtil.slightlyBrighter(color);
                    }
                    break block3;
                }
                if (this.a >= 0) break block3;
                for (int i3 = -this.a; i3 >= 0; --i3) {
                    color = IlvColorUtil.slightlyDarker(color);
                }
            }
            return color;
        }
    }

    public static abstract class ColorChange
    extends Change {
        protected ColorChange() {
        }

        public IlvStyle change(IlvStyle ilvStyle) {
            boolean bl = false;
            Paint paint = null;
            if (ilvStyle.isFillOn()) {
                paint = ilvStyle.getFillPaint();
                bl = true;
            } else if (ilvStyle.isStrokeOn()) {
                paint = ilvStyle.getStrokePaint();
            }
            if (paint instanceof Color) {
                paint = this.changeColor((Color)paint);
            } else if (paint instanceof IlvPattern) {
                IlvPattern ilvPattern = (IlvPattern)paint;
                Color color = ilvPattern.getBackground();
                if (color != null) {
                    paint = new IlvPattern(ilvPattern.getType(), ilvPattern.getForeground(), this.changeColor(color));
                }
            } else if (paint instanceof IlvLinearGradientPaint) {
                IlvLinearGradientPaint ilvLinearGradientPaint = (IlvLinearGradientPaint)paint;
                Color[] colorArray = ilvLinearGradientPaint.getColors();
                int n2 = colorArray.length;
                while (--n2 >= 0) {
                    colorArray[n2] = this.changeColor(colorArray[n2]);
                }
                paint = new IlvLinearGradientPaint(ilvLinearGradientPaint.getStart(), ilvLinearGradientPaint.getEnd(), ilvLinearGradientPaint.getStops(), colorArray, ilvLinearGradientPaint.getSpreadMethod(), ilvLinearGradientPaint.isAdapting());
            } else if (paint instanceof IlvRadialGradientPaint) {
                IlvRadialGradientPaint ilvRadialGradientPaint = (IlvRadialGradientPaint)paint;
                Color[] colorArray = ilvRadialGradientPaint.getColors();
                int n3 = colorArray.length;
                while (--n3 >= 0) {
                    colorArray[n3] = this.changeColor(colorArray[n3]);
                }
                paint = new IlvRadialGradientPaint(ilvRadialGradientPaint.getCenter(), ilvRadialGradientPaint.getRadius(), ilvRadialGradientPaint.getStops(), colorArray, ilvRadialGradientPaint.getSpreadMethod(), ilvRadialGradientPaint.isAdapting());
            } else if (paint instanceof GradientPaint) {
                GradientPaint gradientPaint = (GradientPaint)paint;
                Color color = this.changeColor(gradientPaint.getColor1());
                Color color2 = this.changeColor(gradientPaint.getColor2());
                paint = new GradientPaint(gradientPaint.getPoint1(), color, gradientPaint.getPoint2(), color2, gradientPaint.isCyclic());
            }
            return bl ? ilvStyle.setFillPaint(paint) : ilvStyle.setStrokePaint(paint);
        }

        protected abstract Color changeColor(Color var1);
    }

    public static abstract class Change {
        protected Change() {
        }

        public IlvChartRenderer change(IlvChartRenderer ilvChartRenderer) {
            IlvStyle[] ilvStyleArray = ilvChartRenderer.getStyles();
            if (ilvStyleArray != null) {
                int n2 = ilvStyleArray.length;
                while (--n2 >= 0) {
                    ilvStyleArray[n2] = this.change(ilvStyleArray[n2]);
                }
                ilvChartRenderer.setStyles(ilvStyleArray);
            }
            return ilvChartRenderer;
        }

        public abstract IlvStyle change(IlvStyle var1);
    }

    private static final class Drawing2DHintKey
    extends RenderingHints.Key {
        private static Drawing2DHintKey a = null;

        static Drawing2DHintKey a() {
            boolean bl = false;
            int n2 = (int)System.currentTimeMillis();
            int n3 = 1000;
            Drawing2DHintKey drawing2DHintKey = null;
            while (!bl && --n3 > 0) {
                try {
                    drawing2DHintKey = new Drawing2DHintKey(n2++);
                    bl = true;
                }
                catch (Throwable throwable) {}
            }
            a = drawing2DHintKey;
            return a;
        }

        private Drawing2DHintKey(int n2) {
            super(n2);
        }

        public boolean isCompatibleValue(Object object) {
            return object == a || object == b;
        }
    }
}

