/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvDataInterval;

public class IlvLogarithmicAxisTransformer
extends IlvAxisTransformer {
    private double a;
    private double b;

    public IlvLogarithmicAxisTransformer() {
        this(10.0);
    }

    public IlvLogarithmicAxisTransformer(double d2) {
        this.setLogBase(d2);
    }

    public void setLogBase(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Logarithmic base must be strictly positive");
        }
        this.a = d2;
        this.b = Math.log(d2);
        this.transformerChanged();
    }

    public final double getLogBase() {
        return this.a;
    }

    public double apply(double d2) throws IlvAxisTransformerException {
        if (d2 <= 0.0) {
            return 0.0;
        }
        return Math.log(d2) / this.b;
    }

    public double inverse(double d2) throws IlvAxisTransformerException {
        return Math.exp(d2 * this.b);
    }

    public boolean validateInterval(IlvDataInterval ilvDataInterval) {
        boolean bl = false;
        if (this.getLogBase() > 1.0) {
            double d2 = ilvDataInterval.min;
            double d3 = 1.0E-6;
            double d4 = 0.0;
            if (d2 <= 0.0) {
                d4 = 0.0;
            } else {
                if (d2 + d3 > Double.MAX_VALUE) {
                    d3 = 0.0;
                }
                d4 = Math.floor(Math.log(d2) / this.b + d3);
            }
            ilvDataInterval.min = Math.pow(this.getLogBase(), d4);
            if (d2 != ilvDataInterval.min) {
                bl = true;
            }
            d4 = 0.0;
            d3 = 1.0E-6;
            d2 = ilvDataInterval.max;
            if (d2 <= 0.0) {
                d4 = 0.0;
            } else {
                if (d2 + d3 > Double.MAX_VALUE) {
                    d3 = 0.0;
                }
                d4 = Math.floor(Math.log(d2) / this.b + d3);
                if (Math.pow(this.getLogBase(), d4) != d2) {
                    d4 += 1.0;
                }
            }
            ilvDataInterval.max = Math.pow(this.getLogBase(), d4);
            if (!bl && d2 != ilvDataInterval.max) {
                bl = true;
            }
        }
        return bl;
    }
}

