/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvDataInterval;

public class IlvLocalZoomAxisTransformer
extends IlvAxisTransformer {
    private IlvDataInterval a;
    private double b;
    private boolean c;

    public IlvLocalZoomAxisTransformer(IlvDataInterval ilvDataInterval, double d2, boolean bl) {
        this(ilvDataInterval.min, ilvDataInterval.max, d2, bl);
    }

    public IlvLocalZoomAxisTransformer(double d2, double d3, double d4, boolean bl) {
        this.a = new IlvDataInterval(d2, d3);
        this.b = d4;
        this.c = bl;
    }

    public final IlvDataInterval getZoomRange() {
        return new IlvDataInterval(this.a);
    }

    public boolean setZoomRange(double d2, double d3) {
        if (d2 > d3) {
            return false;
        }
        if (this.getAxis() != null) {
            double d4 = this.a.getMin();
            double d5 = this.a.getMax();
            this.a.set(d2, d3);
            IlvDataInterval ilvDataInterval = this.getTransformedRange();
            IlvDataInterval ilvDataInterval2 = this.getAxis().getVisibleRange();
            if (!ilvDataInterval2.contains(this.a)) {
                this.a.set(d4, d5);
                return false;
            }
        } else {
            this.a.set(d2, d3);
        }
        this.transformerChanged();
        return true;
    }

    public final double getZoomFactor() {
        return this.b;
    }

    public boolean setZoomFactor(double d2) {
        if (d2 < 1.0) {
            return false;
        }
        if (this.getAxis() != null) {
            double d3 = this.b;
            this.b = d2;
            IlvDataInterval ilvDataInterval = this.getTransformedRange();
            if (!this.getAxis().getVisibleRange().contains(ilvDataInterval)) {
                this.b = d3;
                return false;
            }
            this.transformerChanged();
        } else {
            this.b = d2;
        }
        return true;
    }

    public final boolean isContinuous() {
        return this.c;
    }

    public void setContinuous(boolean bl) {
        this.c = bl;
        this.transformerChanged();
    }

    public IlvDataInterval getTransformedRange() {
        double d2 = this.a.getMiddle();
        double d3 = this.b * this.a.getLength() / 2.0;
        IlvDataInterval ilvDataInterval = new IlvDataInterval(d2 - d3, d2 + d3);
        if (this.getAxis() != null) {
            ilvDataInterval.intersection(this.getAxis().getVisibleRange());
        }
        return ilvDataInterval;
    }

    public double apply(double d2) throws IlvAxisTransformerException {
        if (this.b == 1.0 || this.a.getLength() == 0.0) {
            return d2;
        }
        IlvDataInterval ilvDataInterval = this.getTransformedRange();
        if (this.a.isInside(d2)) {
            double d3 = ilvDataInterval.getLength() / this.a.getLength();
            d2 = ilvDataInterval.getMin() + d3 * (d2 - this.a.getMin());
        } else if (this.isContinuous()) {
            IlvDataInterval ilvDataInterval2 = this.getAxis().getVisibleRange();
            if (this.a.isBefore(d2)) {
                d2 = this.a.getMin() == ilvDataInterval2.getMin() ? ilvDataInterval2.getMin() : ilvDataInterval2.getMin() + (d2 - ilvDataInterval2.getMin()) * (ilvDataInterval.getMin() - ilvDataInterval2.getMin()) / (this.a.getMin() - ilvDataInterval2.getMin());
            } else if (this.a.isAfter(d2)) {
                d2 = ilvDataInterval2.getMax() == this.a.getMax() ? ilvDataInterval2.getMax() : ilvDataInterval.getMax() + (d2 - this.a.getMax()) * (ilvDataInterval2.getMax() - ilvDataInterval.getMax()) / (ilvDataInterval2.getMax() - this.a.getMax());
            }
        } else if (d2 >= ilvDataInterval.getMin() && this.a.isBefore(d2)) {
            d2 = ilvDataInterval.getMin();
        } else if (this.a.isAfter(d2) && d2 <= ilvDataInterval.getMax()) {
            d2 = ilvDataInterval.getMax();
        }
        return d2;
    }

    public double[] apply(double[] dArray, int n2) throws IlvAxisTransformerException {
        if (this.b == 1.0 || this.a.getLength() == 0.0) {
            return dArray;
        }
        IlvDataInterval ilvDataInterval = this.getTransformedRange();
        double d2 = ilvDataInterval.getLength() / this.a.getLength();
        if (this.isContinuous()) {
            IlvDataInterval ilvDataInterval2 = this.getAxis().getVisibleRange();
            double d3 = this.a.getMin() == ilvDataInterval2.getMin() ? 0.0 : (ilvDataInterval.getMin() - ilvDataInterval2.getMin()) / (this.a.getMin() - ilvDataInterval2.getMin());
            double d4 = ilvDataInterval2.getMax() == this.a.getMax() ? 0.0 : (ilvDataInterval2.getMax() - ilvDataInterval.getMax()) / (ilvDataInterval2.getMax() - this.a.getMax());
            for (int i2 = 0; i2 < n2; ++i2) {
                double d5 = dArray[i2];
                if (this.a.isInside(d5)) {
                    dArray[i2] = ilvDataInterval.getMin() + d2 * (d5 - this.a.getMin());
                    continue;
                }
                if (this.a.isBefore(d5)) {
                    dArray[i2] = ilvDataInterval2.getMin() + (d5 - ilvDataInterval2.getMin()) * d3;
                    continue;
                }
                if (!this.a.isAfter(d5)) continue;
                dArray[i2] = ilvDataInterval.getMax() + (d5 - this.a.getMax()) * d4;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d6 = dArray[i3];
                if (this.a.isInside(d6)) {
                    dArray[i3] = ilvDataInterval.getMin() + d2 * (d6 - this.a.getMin());
                    continue;
                }
                if (d6 >= ilvDataInterval.getMin() && this.a.isBefore(d6)) {
                    dArray[i3] = ilvDataInterval.getMin();
                    continue;
                }
                if (!this.a.isAfter(d6) || !(d6 <= ilvDataInterval.getMax())) continue;
                dArray[i3] = ilvDataInterval.getMax();
            }
        }
        return dArray;
    }

    public double inverse(double d2) throws IlvAxisTransformerException {
        if (this.b == 1.0 || this.a.getLength() == 0.0) {
            return d2;
        }
        IlvDataInterval ilvDataInterval = this.getTransformedRange();
        IlvDataInterval ilvDataInterval2 = this.getAxis().getVisibleRange();
        if (ilvDataInterval.isInside(d2)) {
            double d3 = ilvDataInterval.getLength() / this.a.getLength();
            d2 = this.a.getMin() + (d2 - ilvDataInterval.getMin()) / d3;
        } else if (this.isContinuous()) {
            if (ilvDataInterval.isBefore(d2)) {
                d2 = this.a.getMin() == ilvDataInterval2.getMin() ? ilvDataInterval2.getMin() : ilvDataInterval2.getMin() + (d2 - ilvDataInterval2.getMin()) / (ilvDataInterval.getMin() - ilvDataInterval2.getMin()) * (this.a.getMin() - ilvDataInterval2.getMin());
            } else if (ilvDataInterval.isAfter(d2)) {
                d2 = ilvDataInterval2.getMax() == this.a.getMax() ? this.a.getMax() : this.a.getMax() + (d2 - ilvDataInterval.getMax()) / (ilvDataInterval2.getMax() - ilvDataInterval.getMax()) * (ilvDataInterval2.getMax() - this.a.getMax());
            }
        } else if (d2 == ilvDataInterval.getMin()) {
            d2 = this.a.getMin();
        } else if (d2 == ilvDataInterval.getMax()) {
            d2 = this.a.getMax();
        }
        return d2;
    }

    public boolean validateInterval(IlvDataInterval ilvDataInterval) {
        if (!ilvDataInterval.contains(this.a)) {
            ilvDataInterval.add(this.a);
            return true;
        }
        return false;
    }
}

