/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvDoubleArrayPool;
import java.io.Serializable;

public class IlvDoublePoints
implements Serializable {
    private static final double[] a = new double[0];
    int b;
    double[] c;
    double[] d;

    public IlvDoublePoints() {
        this(0, a, a);
    }

    public IlvDoublePoints(int n2, double[] dArray, double[] dArray2) {
        this.c = dArray;
        this.d = dArray2;
        this.b = n2;
    }

    public IlvDoublePoints(int n2) {
        this.b = 0;
        this.c = IlvDoubleArrayPool.take(n2, this);
        this.d = IlvDoubleArrayPool.take(n2, this);
    }

    public IlvDoublePoints(double d2, double d3) {
        this(1);
        this.add(d2, d3);
    }

    public void dispose() {
        IlvDoubleArrayPool.release(this.c);
        IlvDoubleArrayPool.release(this.d);
    }

    public void add(double d2, double d3) {
        if (this.c.length == this.b || this.d.length == this.b) {
            this.add(new double[]{d2}, new double[]{d3}, 1);
        } else {
            this.c[this.b] = d2;
            this.d[this.b++] = d3;
        }
    }

    public void add(double[] dArray, double[] dArray2, int n2) {
        int n3 = this.b + n2;
        if (this.c != a) {
            if (n3 > this.c.length) {
                this.c = IlvDoubleArrayPool.reAlloc(this.c, n3, this);
            }
            if (n3 > this.d.length) {
                this.d = IlvDoubleArrayPool.reAlloc(this.d, n3, this);
            }
        } else {
            this.c = IlvDoubleArrayPool.take(n2, this);
            this.d = IlvDoubleArrayPool.take(n2, this);
        }
        System.arraycopy(dArray, 0, this.c, this.b, n2);
        System.arraycopy(dArray2, 0, this.d, this.b, n2);
        this.b = n3;
    }

    public void add(int n2, double[] dArray, double[] dArray2, int n3) {
        if (n2 < 0 || n2 > this.b) {
            throw new IndexOutOfBoundsException("Insertion index out of bounds");
        }
        if (n2 == this.b) {
            this.add(dArray, dArray2, n3);
            return;
        }
        int n4 = this.b + n3;
        double[] dArray3 = IlvDoubleArrayPool.take(this.b);
        System.arraycopy(this.c, 0, dArray3, 0, this.b);
        if (n4 > this.c.length) {
            IlvDoubleArrayPool.release(this.c);
            this.c = IlvDoubleArrayPool.take(n4, this);
            if (n2 > 0) {
                System.arraycopy(dArray3, 0, this.c, 0, n2);
            }
        }
        System.arraycopy(dArray, 0, this.c, n2, n3);
        System.arraycopy(dArray3, n2, this.c, n2 + n3, this.b - n2);
        System.arraycopy(this.d, 0, dArray3, 0, this.b);
        if (n4 > this.d.length) {
            IlvDoubleArrayPool.release(this.d);
            this.d = IlvDoubleArrayPool.take(n4, this);
            if (n2 > 0) {
                System.arraycopy(dArray3, 0, this.d, 0, n2);
            }
        }
        System.arraycopy(dArray2, 0, this.d, n2, n3);
        System.arraycopy(dArray3, n2, this.d, n2 + n3, this.b - n2);
        this.b = n4;
        IlvDoubleArrayPool.release(dArray3);
    }

    public void remove(int n2, int n3) {
        if (n3 <= 0) {
            throw new IndexOutOfBoundsException("count must be strictly positive");
        }
        int n4 = n2 + n3;
        int n5 = this.b - n4;
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("Points out of bounds");
        }
        if (n5 > 0) {
            System.arraycopy(this.c, n4, this.c, n2, n5);
            System.arraycopy(this.d, n4, this.d, n2, n5);
        }
        this.b -= n3;
    }

    public final void add(IlvDoublePoints ilvDoublePoints) {
        this.add(ilvDoublePoints.c, ilvDoublePoints.d, ilvDoublePoints.b);
    }

    public final double getX(int n2) {
        return this.c[n2];
    }

    public final int getXFloor(int n2) {
        return IlvGraphicUtil.toInt(this.c[n2]);
    }

    public final double getY(int n2) {
        return this.d[n2];
    }

    public final int getYFloor(int n2) {
        return IlvGraphicUtil.toInt(this.d[n2]);
    }

    public final void setX(int n2, double d2) {
        this.c[n2] = d2;
    }

    public final void setY(int n2, double d2) {
        this.d[n2] = d2;
    }

    public final void set(int n2, double d2, double d3) {
        this.c[n2] = d2;
        this.d[n2] = d3;
    }

    public final int size() {
        return this.b;
    }

    public final double[] getXValues() {
        return this.c;
    }

    public final double[] getXValuesClone() {
        double[] dArray = new double[this.b];
        System.arraycopy(this.c, 0, dArray, 0, this.b);
        return dArray;
    }

    public final double[] getYValues() {
        return this.d;
    }

    public final double[] getYValuesClone() {
        double[] dArray = new double[this.b];
        System.arraycopy(this.d, 0, dArray, 0, this.b);
        return dArray;
    }

    public void setSize(int n2) {
        if (n2 > this.c.length) {
            throw new IndexOutOfBoundsException("Number of points cannot exceed available space");
        }
        this.b = n2;
    }

    public void reset() {
        this.setSize(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.b);
        stringBuffer.append('[');
        for (int i2 = 0; i2 < this.b; ++i2) {
            stringBuffer.append('(');
            stringBuffer.append(this.c[i2]);
            stringBuffer.append(',');
            stringBuffer.append(this.d[i2]);
            stringBuffer.append(')');
            if (i2 != this.b - 1) {
                stringBuffer.append(", ");
            }
            if (i2 % 16 != 0 || i2 <= 0) continue;
            stringBuffer.append('\n');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

