/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.event.IlvListenerList;
import ilog.views.chart.util.internal.IlvFlags;
import java.io.Serializable;

public class IlvAxis
implements Serializable {
    static final int a = 5;
    static final double b = 1.0E-14;
    public static Crossing MAX_VALUE = new MaxCrossing();
    public static Crossing MIN_VALUE = new MinCrossing();
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 3;
    private static final int f = 4;
    private static final int g = 32;
    private static final int h = 64;
    private static final int i = 7;
    private int j;
    private IlvFlags k = new IlvFlags(7);
    private IlvListenerList l = new IlvListenerList();
    private IlvDataInterval m = new IlvDataInterval();
    private IlvDataInterval n = new IlvDataInterval(-1.7976931348623157E308, Double.MAX_VALUE);
    private IlvAxisTransformer o;
    private IlvChart p;

    IlvAxis() {
    }

    IlvAxis(int n2) {
        this.j = n2;
    }

    void a(IlvChart ilvChart) {
        this.p = ilvChart;
    }

    public final boolean isXAxis() {
        return this.j == 1;
    }

    public final boolean isYAxis() {
        return this.j == 2;
    }

    public final int getType() {
        return this.j;
    }

    void a(int n2) {
        this.j = n2;
    }

    public void setReversed(boolean bl) {
        if (bl != this.isReversed()) {
            this.k.setFlag(64, bl);
            this.b(3);
        }
    }

    public final boolean isReversed() {
        return this.k.getFlag(64);
    }

    public IlvDataInterval getDataRange() {
        return new IlvDataInterval(this.n);
    }

    public final double getDataMin() {
        return this.n.getMin();
    }

    public final double getDataMax() {
        return this.n.getMax();
    }

    public final boolean isBounded() {
        return this.n.getMin() != -1.7976931348623157E308 && this.n.getMax() != Double.MAX_VALUE;
    }

    public final IlvDataInterval getVisibleRange() {
        if (this.p != null && this.p.isPrinting()) {
            return new IlvDataInterval(this.p.getPrintContext().getRange(this.p.a(this).b()));
        }
        return new IlvDataInterval(this.m);
    }

    public final double getVisibleMin() {
        if (this.p != null && this.p.isPrinting()) {
            return this.p.getPrintContext().getRange(this.p.a(this).b()).getMin();
        }
        return this.m.getMin();
    }

    public final double getVisibleMax() {
        if (this.p != null && this.p.isPrinting()) {
            return this.p.getPrintContext().getRange(this.p.a(this).b()).getMax();
        }
        return this.m.getMax();
    }

    public IlvDataInterval getTVisibleRange() {
        IlvDataInterval ilvDataInterval = this.getVisibleRange();
        if (this.o != null) {
            try {
                this.o.apply(ilvDataInterval);
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvDataInterval = new IlvDataInterval();
            }
        }
        return ilvDataInterval;
    }

    private boolean d() {
        if (!this.isBounded() || !this.k.getFlag(4)) {
            return false;
        }
        return this.a(this.n.getMin(), this.n.getMax(), true);
    }

    final boolean a(IlvDataInterval ilvDataInterval) {
        double d2 = this.isAutoDataMin() ? ilvDataInterval.getMin() : this.getDataMin();
        double d3 = this.isAutoDataMax() ? ilvDataInterval.getMax() : this.getDataMax();
        return this.a(d2, d3);
    }

    public void setAutoVisibleRange(boolean bl) {
        if (bl == this.isAutoVisibleRange()) {
            return;
        }
        this.k.setFlag(4, bl);
        if (bl) {
            this.d();
        }
    }

    public final boolean isAutoVisibleRange() {
        return this.k.getFlag(4);
    }

    public void setVisibleRange(double d2, double d3) {
        if (d2 > d3) {
            throw new IllegalArgumentException("Empty range");
        }
        if (d2 == this.getVisibleMin() && d3 == this.getVisibleMax()) {
            return;
        }
        this.k.setFlag(4, false);
        this.a(d2, d3, true);
    }

    public void setVisibleRange(IlvDataInterval ilvDataInterval) {
        this.setVisibleRange(ilvDataInterval.getMin(), ilvDataInterval.getMax());
    }

    public void setVisibleMin(double d2) {
        this.setVisibleRange(d2, this.getVisibleMax());
    }

    public void setVisibleMax(double d2) {
        this.setVisibleRange(this.getVisibleMin(), d2);
    }

    public void translateVisibleRange(double d2) {
        if ((d2 = this.a(d2)) != 0.0) {
            this.setVisibleRange(this.getVisibleMin() + d2, this.getVisibleMax() + d2);
        }
    }

    final boolean a() {
        return this.isAutoDataMin() || this.isAutoDataMax();
    }

    public void setAutoDataRange(boolean bl) {
        if (bl == (this.isAutoDataMax() && this.isAutoDataMin())) {
            return;
        }
        this.k.setFlag(2, bl);
        this.k.setFlag(1, bl);
        if (bl && this.p != null) {
            this.p.d(this);
        }
    }

    public void setAutoDataMax(boolean bl) {
        if (bl == this.isAutoDataMax()) {
            return;
        }
        this.k.setFlag(1, bl);
        if (bl && this.p != null) {
            this.p.d(this);
        }
    }

    public final boolean isAutoDataMax() {
        return this.k.getFlag(1);
    }

    public void setAutoDataMin(boolean bl) {
        if (bl == this.isAutoDataMin()) {
            return;
        }
        this.k.setFlag(2, bl);
        if (bl && this.p != null) {
            this.p.d(this);
        }
    }

    public final boolean isAutoDataMin() {
        return this.k.getFlag(2);
    }

    public void setDataRange(double d2, double d3) {
        if (d2 > d3) {
            throw new IllegalArgumentException("Empty range");
        }
        this.k.setFlag(2, false);
        this.k.setFlag(1, false);
        this.a(d2, d3);
    }

    public void setDataRange(IlvDataInterval ilvDataInterval) {
        this.setDataRange(ilvDataInterval.getMin(), ilvDataInterval.getMax());
    }

    public void setDataMin(double d2) {
        this.k.setFlag(2, false);
        this.a(d2, this.getDataMax());
    }

    public void setDataMax(double d2) {
        this.k.setFlag(1, false);
        this.a(this.getDataMin(), d2);
    }

    private boolean a(double d2, double d3) {
        IlvDataInterval ilvDataInterval = new IlvDataInterval(d2, d3);
        if (this.getTransformer() != null) {
            this.getTransformer().validateInterval(ilvDataInterval);
        }
        if (this.n.equals(ilvDataInterval)) {
            return false;
        }
        this.a(ilvDataInterval, true, false);
        IlvDataInterval ilvDataInterval2 = this.n;
        this.n = ilvDataInterval;
        this.a(ilvDataInterval2, false, false);
        return this.d() || this.e();
    }

    boolean a(double d2, double d3, boolean bl) {
        if (bl && d2 == this.getVisibleMin() && d3 == this.getVisibleMax()) {
            return false;
        }
        IlvDataInterval ilvDataInterval = new IlvDataInterval(d2, d3);
        this.c(ilvDataInterval);
        if (!this.b(ilvDataInterval) || ilvDataInterval.equals(this.m)) {
            return false;
        }
        this.a(ilvDataInterval, true, true);
        this.c(ilvDataInterval);
        IlvDataInterval ilvDataInterval2 = this.m;
        this.m = ilvDataInterval;
        this.a(ilvDataInterval2, false, true);
        return true;
    }

    private final boolean b(IlvDataInterval ilvDataInterval) {
        return !ilvDataInterval.isEmpty() && Math.abs(ilvDataInterval.getLength() / ilvDataInterval.getMin()) > 1.0E-14;
    }

    private final boolean e() {
        return this.a(this.getVisibleMin(), this.getVisibleMax(), false);
    }

    private void c(IlvDataInterval ilvDataInterval) {
        boolean bl = false;
        int n2 = 0;
        do {
            if (this.o != null) {
                bl = this.o.validateInterval(ilvDataInterval);
            }
            boolean bl2 = bl = this.d(ilvDataInterval) || bl;
        } while (n2++ < 5 && bl);
    }

    private boolean d(IlvDataInterval ilvDataInterval) {
        if (this.n.contains(ilvDataInterval)) {
            return false;
        }
        ilvDataInterval.intersection(this.n);
        if (ilvDataInterval.isEmpty()) {
            if (ilvDataInterval.getMin() > this.getDataMax()) {
                ilvDataInterval.set(this.getDataMax(), this.getDataMax());
            } else {
                ilvDataInterval.set(this.getDataMin(), this.getDataMin());
            }
        }
        return true;
    }

    public final IlvAxisTransformer getTransformer() {
        return this.o;
    }

    public void setTransformer(IlvAxisTransformer ilvAxisTransformer) {
        if (ilvAxisTransformer != null) {
            if (ilvAxisTransformer.getAxis() != null) {
                throw new IllegalArgumentException("Transformer already attached to an axis");
            }
            ilvAxisTransformer.a(this);
        }
        if (this.o != null) {
            this.o.a(null);
        }
        this.o = ilvAxisTransformer;
        this.b();
    }

    public final boolean isAdjusting() {
        return this.k.getFlag(32);
    }

    public final void setAdjusting(boolean bl) {
        if (bl != this.isAdjusting()) {
            this.k.setFlag(32, bl);
            this.b(1);
        }
    }

    public synchronized void addAxisListener(AxisListener axisListener) {
        this.l.add(axisListener);
    }

    public synchronized void removeAxisListener(AxisListener axisListener) {
        this.l.remove(axisListener);
    }

    void b() {
        this.b(2);
        this.e();
    }

    void b(int n2) {
        Object[] objectArray = this.l.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        AxisChangeEvent axisChangeEvent = new AxisChangeEvent(this, n2, this.isAdjusting());
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((AxisListener)objectArray[i2]).axisChanged(axisChangeEvent);
        }
    }

    void a(IlvDataInterval ilvDataInterval, boolean bl, boolean bl2) {
        if (this.l.getListenerCount() == 0) {
            return;
        }
        Object[] objectArray = this.l.getListenerList();
        AxisRangeEvent axisRangeEvent = new AxisRangeEvent(this, ilvDataInterval, bl, this.isAdjusting(), bl2);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((AxisListener)objectArray[i2]).axisRangeChanged(axisRangeEvent);
        }
    }

    private final double a(double d2) {
        if (d2 > 0.0 && this.getDataMax() >= this.getVisibleMax()) {
            return Math.min(this.getDataMax() - this.getVisibleMax(), d2);
        }
        if (d2 < 0.0 && this.getDataMin() <= this.getVisibleMin()) {
            return Math.max(this.getDataMin() - this.getVisibleMin(), d2);
        }
        return 0.0;
    }

    public String toString() {
        return this.getClass().getName() + (this.isXAxis() ? " X" : " Y") + " Visi: " + this.m + " Data: " + this.n;
    }

    final void c() {
        this.setTransformer(null);
        this.setReversed(false);
        this.setAutoVisibleRange(true);
        this.setAutoDataRange(true);
    }

    public void synchronizeWith(IlvAxis ilvAxis, boolean bl) {
        if (ilvAxis == this || ilvAxis == null) {
            throw new IllegalArgumentException("Invalid axis");
        }
        if (!bl) {
            Synchronizer.c(ilvAxis, this);
        } else {
            Synchronizer.d(ilvAxis, this);
        }
    }

    private static class Synchronizer
    implements AxisListener,
    Serializable {
        private IlvAxis a;
        private IlvAxis b;
        private boolean c;

        private Synchronizer(IlvAxis ilvAxis, IlvAxis ilvAxis2) {
            this.a = ilvAxis;
            this.b = ilvAxis2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
            if (this.c || axisRangeEvent.isAboutToChangeEvent()) {
                return;
            }
            try {
                IlvAxis ilvAxis = axisRangeEvent.getAxis() == this.a ? this.b : this.a;
                this.c = true;
                double d2 = axisRangeEvent.getNewMin();
                double d3 = axisRangeEvent.getNewMax();
                if (d2 <= d3) {
                    if (axisRangeEvent.isVisibleRangeEvent()) {
                        ilvAxis.setVisibleRange(d2, d3);
                    } else {
                        ilvAxis.setDataRange(d2, d3);
                    }
                }
            }
            finally {
                this.c = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void axisChanged(AxisChangeEvent axisChangeEvent) {
            block7: {
                block6: {
                    if (this.c) break block6;
                    if (axisChangeEvent.getType() == 1) break block7;
                }
                return;
            }
            IlvAxis ilvAxis = axisChangeEvent.getAxis() == this.a ? this.b : this.a;
            try {
                this.c = true;
                ilvAxis.setAdjusting(axisChangeEvent.isAdjusting());
            }
            finally {
                this.c = false;
            }
        }

        private static void c(IlvAxis ilvAxis, IlvAxis ilvAxis2) {
            Synchronizer synchronizer = Synchronizer.e(ilvAxis, ilvAxis2);
            Synchronizer synchronizer2 = Synchronizer.e(ilvAxis2, ilvAxis);
            if (synchronizer != null) {
                ilvAxis.removeAxisListener(synchronizer);
            }
            if (synchronizer2 != null) {
                ilvAxis2.removeAxisListener(synchronizer2);
            }
        }

        private static void d(IlvAxis ilvAxis, IlvAxis ilvAxis2) {
            IlvDataInterval ilvDataInterval;
            Synchronizer synchronizer = Synchronizer.e(ilvAxis, ilvAxis2);
            Synchronizer synchronizer2 = Synchronizer.e(ilvAxis2, ilvAxis);
            if (synchronizer != null && synchronizer2 != null) {
                return;
            }
            if (synchronizer != null) {
                ilvAxis.removeAxisListener(synchronizer);
            }
            if (synchronizer2 != null) {
                ilvAxis2.removeAxisListener(synchronizer2);
            }
            if (!(ilvDataInterval = ilvAxis.getDataRange()).isEmpty()) {
                ilvAxis2.setDataRange(ilvDataInterval);
            }
            if (!(ilvDataInterval = ilvAxis.getVisibleRange()).isEmpty()) {
                ilvAxis2.setVisibleRange(ilvDataInterval);
            }
            Synchronizer synchronizer3 = new Synchronizer(ilvAxis, ilvAxis2);
            ilvAxis.addAxisListener(synchronizer3);
            ilvAxis2.addAxisListener(synchronizer3);
        }

        private static Synchronizer e(IlvAxis ilvAxis, IlvAxis ilvAxis2) {
            Object[] objectArray = ilvAxis.l.getListenerList();
            int n2 = objectArray.length;
            while (--n2 >= 0) {
                if (!(objectArray[n2] instanceof Synchronizer)) continue;
                Synchronizer synchronizer = (Synchronizer)objectArray[n2];
                if (synchronizer.a != ilvAxis2 && synchronizer.b != ilvAxis2) continue;
                return synchronizer;
            }
            return null;
        }
    }

    static class AnchoredCrossing
    implements Crossing,
    Serializable {
        double a;

        AnchoredCrossing(double d2) {
            this.a = d2;
        }

        public double getValue(IlvAxis ilvAxis) {
            return this.a;
        }
    }

    static class MinCrossing
    extends FixedCrossing {
        private MinCrossing() {
        }

        public double getValue(IlvAxis ilvAxis) {
            return ilvAxis.getVisibleMin();
        }
    }

    static class MaxCrossing
    extends FixedCrossing {
        private MaxCrossing() {
        }

        public double getValue(IlvAxis ilvAxis) {
            return ilvAxis.getVisibleMax();
        }
    }

    static abstract class FixedCrossing
    implements Crossing,
    Serializable {
        FixedCrossing() {
        }

        public abstract double getValue(IlvAxis var1);
    }

    public static interface Crossing {
        public double getValue(IlvAxis var1);
    }
}

