/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.data;

import hk.com.realink.feed.toolkit.data.Tt2;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SctyTTHistory {
    private String companyCode = "";
    private TreeMap sctyTTMap = new TreeMap();
    private int ttHistorySeq = -1;

    private SctyTTHistory() {
    }

    public SctyTTHistory(String companyCode) {
    }

    public int getLatestSeqNum() {
        return this.ttHistorySeq;
    }

    public void putTtArray(Tt2[] tts) {
        if (tts.length == 0) {
            return;
        }
        if (tts[0].tickerKey <= this.ttHistorySeq) {
            this.sctyTTMap.clear();
        }
        this.ttHistorySeq = tts[tts.length - 1].tickerKey;
        for (int i2 = 0; i2 < tts.length; ++i2) {
            this.sctyTTMap.put(new Integer(tts[i2].tickerKey), tts[i2]);
        }
    }

    public void putTt(Tt2 tt) {
        Tt2[] tts = new Tt2[]{tt};
        this.putTtArray(tts);
    }

    public Tt2[] toTtArray() {
        return this.sctyTTMap.values().toArray(new Tt2[0]);
    }

    public SctyTTHistory getTTTurnoverLargerEqual(long turnover) {
        SctyTTHistory new_ttHistory = new SctyTTHistory(this.companyCode);
        Tt2[] tts = this.toTtArray();
        for (int i2 = 0; i2 < tts.length; ++i2) {
            if (!((float)tts[i2].tradeQty * tts[i2].tradePrice >= (float)turnover)) continue;
            new_ttHistory.putTt(tts[i2]);
        }
        return new_ttHistory;
    }

    public SctyTTHistory getTTQtyLargerEqual(int qty) {
        SctyTTHistory new_ttHistory = new SctyTTHistory(this.companyCode);
        Tt2[] tts = this.toTtArray();
        for (int i2 = 0; i2 < tts.length; ++i2) {
            if (tts[i2].tradeQty < qty) continue;
            new_ttHistory.putTt(tts[i2]);
        }
        return new_ttHistory;
    }

    public SctyTTHistory getTTQtySmallerEqual(int qty) {
        SctyTTHistory new_ttHistory = new SctyTTHistory(this.companyCode);
        Tt2[] tts = this.toTtArray();
        for (int i2 = 0; i2 < tts.length; ++i2) {
            if (tts[i2].tradeQty > qty) continue;
            new_ttHistory.putTt(tts[i2]);
        }
        return new_ttHistory;
    }

    public String paramString() {
        String s2 = "\nSctyTTHistory value :\n";
        StringBuffer strBuff = new StringBuffer(s2);
        Iterator it = this.sctyTTMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            strBuff.append("key = " + (Integer)entry.getKey() + " ");
            strBuff.append("tt2 = " + ((Tt2)((Object)entry.getValue())).paramString() + "\n");
        }
        return strBuff.toString();
    }
}

