/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.data;

import hk.com.realink.feed.toolkit.data.SctyTTCompound;
import hk.com.realink.feed.toolkit.data.SctyTTRaw;
import hk.com.realink.feed.toolkit.data.Tt2;
import java.util.HashMap;

public class RKSctyTTCache {
    private static HashMap hashHistory = new HashMap();

    private RKSctyTTCache() {
    }

    public static synchronized void putTtRawData(SctyTTRaw raw) {
        Tt2[] tts = raw.getTtArray();
        String companyCode = raw.getCompanyCode();
        if (tts.length == 0) {
            return;
        }
        SctyTTCompound sctyTt = (SctyTTCompound)hashHistory.get(companyCode);
        if (sctyTt == null) {
            sctyTt = new SctyTTCompound(companyCode);
            sctyTt.setCompanyShortName(raw.getCompanyShortName());
            sctyTt.setLotSize(raw.getLotSize());
            hashHistory.put(companyCode, sctyTt);
        }
        sctyTt.getSctyTTHistory().putTtArray(tts);
        sctyTt.getSctyTTTimeQty().putTtArray(tts);
        sctyTt.getSctyTTPriceQty().putTtArray(tts);
    }

    public static synchronized SctyTTCompound getSctyTTCompound(String companyCode) {
        return (SctyTTCompound)hashHistory.get(companyCode);
    }

    public static synchronized void remove(String companyCode) {
        hashHistory.remove(companyCode);
    }

    public static synchronized void remove(String[] companyCodes) {
        for (int i2 = 0; i2 < companyCodes.length; ++i2) {
            hashHistory.remove(companyCodes);
        }
    }

    public static synchronized void removeAll() {
        hashHistory.clear();
    }
}

